/*!
	@file		VersionInfo.cpp
	@brief		AvP[Ṽo[W擾A֐܂܂Ă܂B
	@author		Mitsunagi Studio
	@date		08/06/22
	@version	1.00
*/

#include "VersionInfo.h"
#include <stdio.h>
#include <wchar.h>

BOOL VersionInfoGetVersionInfo( VS_FIXEDFILEINFO* outInfo ){
	INT					args;
	UINT				len;
	LPWSTR*				cl;
	DWORD				vifs,ref = 0;
	LPVOID				data;
	VS_FIXEDFILEINFO*	ffi;
	BOOL				result = FALSE;

	cl = CommandLineToArgvW(GetCommandLineW(),&args);
	if(cl){
		vifs = GetFileVersionInfoSize(cl[0],&ref);
		data = malloc(vifs);
		if(data){
			if(GetFileVersionInfo(cl[0],ref,vifs,data)){
				if(VerQueryValue(data,L"\\",(LPVOID*)&ffi,&len)){
					memcpy(outInfo,ffi,sizeof(VS_FIXEDFILEINFO));
					result = TRUE;
				}
			}
			free(data);
		}
		LocalFree(cl);
	}
	return result;
}

BOOL VersionInfoGetVersionStringA( const VS_FIXEDFILEINFO* inInfo, LPSTR outStr, DWORD inLen ){
	int	major,minor,rev;
	if(!inInfo || !outStr || inLen == 0) return FALSE;
	
	major = ((inInfo->dwFileVersionMS >> 16) & 0xffff);
	minor = (inInfo->dwFileVersionMS & 0xffff);
	rev   = ((inInfo->dwFileVersionLS >> 16) & 0xffff);
	if(rev != 0){
		sprintf_s(outStr,inLen,"%d.%02d%c",major,minor,'a' + (rev - 1));
	}else{
		sprintf_s(outStr,inLen,"%d.%02d",major,minor);
	}
	return TRUE;
}

BOOL VersionInfoGetVersionStringW( const VS_FIXEDFILEINFO* inInfo, LPWSTR outStr, DWORD inLen ){
	int	major,minor,rev;
	if(!inInfo || !outStr || inLen == 0) return FALSE;
	
	major = ((inInfo->dwFileVersionMS >> 16) & 0xffff);
	minor = (inInfo->dwFileVersionMS & 0xffff);
	rev   = ((inInfo->dwFileVersionLS >> 16) & 0xffff);
	if(rev != 0){
		swprintf_s(outStr,inLen,L"%d.%02d%c",major,minor,L'a' + (rev - 1));
	}else{
		swprintf_s(outStr,inLen,L"%d.%02d",major,minor);
	}
	return TRUE;
}

