// 
// main.cpp
// 
// Copylight(C) 2007 Ó

#include <windows.h>

#define IDTEXT_KEY 100
//int gIdPos = IDTEXT_KEY;

BYTE gKeyCode[8];
wchar_t gCharCode[8];
HWND gEdits[3][8];
RECT gCharRect = {2,0,68,20};
RECT gKeyRect  = {70,0,122,20};
wchar_t buf[16];
HFONT gFont;


void nextChar(wchar_t c){
	int i;
	gCharCode[7] = gCharCode[6];
	gCharCode[6] = gCharCode[5];
	gCharCode[5] = gCharCode[4];
	gCharCode[4] = gCharCode[3];
	gCharCode[3] = gCharCode[2];
	gCharCode[2] = gCharCode[1];
	gCharCode[1] = gCharCode[0];
	gCharCode[0] = c;
	for(i=0;i<8;++i){
		wsprintf(buf,L"0x%04X",gCharCode[i]);
		SetWindowText(gEdits[0][i],buf);
		if(gCharCode[i]) wsprintf(buf,L"%c",gCharCode[i]);
		else *buf = L'\0';
		SetWindowText(gEdits[1][i],buf);
	}
}

void nextKey(BYTE c){
	int i;
	gKeyCode[7] = gKeyCode[6];
	gKeyCode[6] = gKeyCode[5];
	gKeyCode[5] = gKeyCode[4];
	gKeyCode[4] = gKeyCode[3];
	gKeyCode[3] = gKeyCode[2];
	gKeyCode[2] = gKeyCode[1];
	gKeyCode[1] = gKeyCode[0];
	gKeyCode[0] = c;
	for(i=0;i<8;++i){
		wsprintf(buf,L"0x%02X",gKeyCode[i]);
		SetWindowText(gEdits[2][i],buf);
	}
}

HWND createTextField(HWND hWnd,int x,int y,int w){
	HWND h = CreateWindowEx(WS_EX_CLIENTEDGE,L"EDIT",L"",WS_CHILD|WS_VISIBLE|ES_READONLY|ES_CENTER,
		x,y,w,18,hWnd,NULL,GetModuleHandle(NULL),NULL);
	SendMessage(h,WM_SETFONT,(WPARAM)gFont,TRUE);
	return h;
}

LRESULT CALLBACK WinProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam){
	HDC dc;
	PAINTSTRUCT ps;
	switch (msg){
		case WM_CREATE:
			gEdits[0][0] = createTextField(hWnd,2  ,20 ,46);
			gEdits[0][1] = createTextField(hWnd,2  ,40 ,46);
			gEdits[0][2] = createTextField(hWnd,2  ,60 ,46);
			gEdits[0][3] = createTextField(hWnd,2  ,80 ,46);
			gEdits[0][4] = createTextField(hWnd,2  ,100,46);
			gEdits[0][5] = createTextField(hWnd,2  ,120,46);
			gEdits[0][6] = createTextField(hWnd,2  ,140,46);
			gEdits[0][7] = createTextField(hWnd,2  ,160,46);
			gEdits[1][0] = createTextField(hWnd,50 ,20 ,18);
			gEdits[1][1] = createTextField(hWnd,50 ,40 ,18);
			gEdits[1][2] = createTextField(hWnd,50 ,60 ,18);
			gEdits[1][3] = createTextField(hWnd,50 ,80 ,18);
			gEdits[1][4] = createTextField(hWnd,50 ,100,18);
			gEdits[1][5] = createTextField(hWnd,50 ,120,18);
			gEdits[1][6] = createTextField(hWnd,50 ,140,18);
			gEdits[1][7] = createTextField(hWnd,50 ,160,18);
			gEdits[2][0] = createTextField(hWnd,80 ,20 ,32);
			gEdits[2][1] = createTextField(hWnd,80 ,40 ,32);
			gEdits[2][2] = createTextField(hWnd,80 ,60 ,32);
			gEdits[2][3] = createTextField(hWnd,80 ,80 ,32);
			gEdits[2][4] = createTextField(hWnd,80 ,100,32);
			gEdits[2][5] = createTextField(hWnd,80 ,120,32);
			gEdits[2][6] = createTextField(hWnd,80 ,140,32);
			gEdits[2][7] = createTextField(hWnd,80 ,160,32);
			nextKey(0);
			nextChar(0);
		break;
		case WM_PAINT:
			dc = BeginPaint(hWnd,&ps);
			SelectObject(dc,gFont);
			DrawText(dc,L"KEYDOWN",-1,&gKeyRect,DT_SINGLELINE|DT_VCENTER|DT_CENTER);
			DrawText(dc,L"CHAR",-1,&gCharRect,DT_SINGLELINE|DT_VCENTER|DT_CENTER);
			EndPaint(hWnd,&ps);
		break;
		case WM_CLOSE:
			ShowWindow(hWnd,SW_HIDE);
			PostMessage(hWnd,WM_QUIT,0,0);
		return FALSE;
		case WM_LBUTTONDOWN:
			SetFocus(hWnd);
		break;
		case WM_KEYDOWN:
			nextKey((BYTE)wParam);
		break;
		case WM_CHAR:
			nextChar((wchar_t)wParam);
		break;
	}
	return DefWindowProc(hWnd,msg,wParam,lParam);
}

int xmain(void){
	MSG msg;
	HWND hWnd;
	ZeroMemory(gCharCode,16);
	ZeroMemory(gKeyCode,8);
	{
		WNDCLASSEX wc;
		
		memset(&wc,0,sizeof(WNDCLASSEX));
		wc.cbSize        = sizeof(WNDCLASSEX);
		wc.lpfnWndProc   = WinProc;
		wc.hInstance     = GetModuleHandle(NULL);
		wc.hIcon         = LoadIcon(wc.hInstance,MAKEINTRESOURCE(0));
		wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
		wc.hbrBackground = GetSysColorBrush(COLOR_WINDOW);
		wc.lpszClassName = L"KeyCodeChecker";
		if(!RegisterClassEx(&wc)) return -1;

		gFont = CreateFont(12,0,0,0,400,0,0,0,
			DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
			ANTIALIASED_QUALITY,FIXED_PITCH,L"lr SVbN");

		hWnd = CreateWindow(
			L"KeyCodeChecker",L"KeyCodeCheck",
			WS_CAPTION|WS_SYSMENU|WS_VISIBLE,
			CW_USEDEFAULT,CW_USEDEFAULT,
			124+GetSystemMetrics(SM_CXFRAME)*2,
			182+GetSystemMetrics(SM_CYFRAME)+GetSystemMetrics(SM_CYCAPTION),
			GetDesktopWindow(),
			NULL,
			GetModuleHandle(NULL),
			NULL
		);
		if(!hWnd) return -1;
	}
	while(GetMessage(&msg,NULL,0,0)){
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	DeleteObject(gFont);
	return 0;
}

#ifdef _CONSOLE
int wmain(int argc,wchar_t* argv[]){return xmain();}
#else
int __stdcall wWinMain(HINSTANCE hInst,HINSTANCE hPrev,LPCWSTR cmd,int show){return xmain();}
#endif
