/*!
	@file	genguid.c
	@brief	GUIDl𐶐܂B
	@author	Ó
*/


#include <stdio.h>
#include <Objbase.h>

#pragma comment(lib,"Ole32.lib")

// OLE eLXg̃^CvɂϊΉ
#ifndef OLE2ANSI
#define OLESTR_PRINT_FORMAT "%S"
#else
#define OLESTR_PRINT_FORMAT "%s"
#endif

/*!
	@brief GUID ̋ṕB
*/
typedef union _u {
	GUID	guid;		//!< GUID {́B
	DWORD64	byte64[2];	//!< 64bit \ GUID lB
	DWORD	byte32[4];	//!< 32bit \ GUID lB
	WORD	byte16[8];	//!< 16bit \ GUID lB
	BYTE	byte8[16];	//!<  8bit \ GUID lB
} U;

/*!
	@brief GUID o̓p[^B
*/
typedef enum _EGUID_GENTYPE {
	EGUID_GENTYPE_STRING	= 0x00000000,	//!<       Ő(-g)<-ftHg
	EGUID_GENTYPE_SSTRUCT	= 0x00000001,	//!<  GUID \̂Ő(-s)[]
	EGUID_GENTYPE_S64BITS	= 0x00000002,	//!< 64Bit lzŐ(-q)[]
	EGUID_GENTYPE_S32BITS	= 0x00000004,	//!< 32Bit lzŐ(-d)[]
	EGUID_GENTYPE_S16BITS	= 0x00000008,	//!< 16Bit lzŐ(-w)[]
	EGUID_GENTYPE_S8BITS	= 0x00000010,	//!<  8Bit lzŐ(-b)[]
	EGUID_GENTYPE_USTRUCT	= 0x00000100,	//!<  GUID \̂Ő(-S)[啶]
	EGUID_GENTYPE_U64BITS	= 0x00000200,	//!< 64Bit lzŐ(-Q)[啶]
	EGUID_GENTYPE_U32BITS	= 0x00000400,	//!< 32Bit lzŐ(-D)[啶]
	EGUID_GENTYPE_U16BITS	= 0x00000800,	//!< 16Bit lzŐ(-W)[啶]
	EGUID_GENTYPE_U8BITS	= 0x00001000,	//!<  8Bit lzŐ(-B)[啶]
	EGUID_GENTYPE_GENMASK	= 0x0000ffff,	//!< p[^}XN
	EGUID_GENTYPE_SMALLMASK	= 0x000000ff,	//!< p[^}XN()
	EGUID_GENTYPE_BIGMASK	= 0x0000ff00,	//!< p[^}XN(啶)

	EGUID_GENTYPE_INSPACE	= 0x00000000,	//!< pXy[X
	EGUID_GENTYPE_NOSPACE	= 0x00010000,	//!< pXy[XȂ
	EGUID_GENTYPE_SPACEMASK	= 0x00010000,	//!< pXy[Xݒ}XN

	EGUID_GENTYPE_XSMALL	= 0x00020000,	//!< 'x'
	EGUID_GENTYPE_XBIG		= 0x00040000,	//!< 'x'啶
	EGUID_GENTYPE_XOPT		= 0x00000000,	//!< 'x' option ˑ
	EGUID_GENTYPE_XMASK		= 0x00060000,	//!< 'x'ݒ}XN

	EGUID_GENTYPE_ULLSMALL	= 0x00080000,	//!< "ull"
	EGUID_GENTYPE_ULLBIG	= 0x00100000,	//!< "ull"啶
	EGUID_GENTYPE_ULLOPT	= 0x00000000,	//!< "ull" option ˑ
	EGUID_GENTYPE_ULLMASK	= 0x00180000,	//!< "ull"ݒ}XN

	EGUID_GENTYPE_ERROR		= 0x80000000,	//!< p[^擾G[
} EGUID_GENTYPE;

/*!
	@brief	16ilo͂܂B
	@param	val	[in]	ޒlB
	@param	deg	[in]	B
	@param	opt	[in]	IvVB
*/
static void printHex( DWORD val, int deg, DWORD opt ){
	char	format[] = "0x%00x";
	if(((opt & EGUID_GENTYPE_XSMALL) == 0) && (opt & (EGUID_GENTYPE_BIGMASK | EGUID_GENTYPE_XBIG))){
		format[1] = 'X';
	}
	if(opt & EGUID_GENTYPE_BIGMASK){
		format[5] = 'X';
	}
	format[4] += deg;
	printf(format, val);
}

/*!
	@brief	16ilo͂܂B64bitlpB
	@param	val	[in]	ޒlB
	@param	opt	[in]	IvVB
*/
static void printHex64( DWORD64 val, DWORD opt ){
	char	format[] = "%08x";
	if(opt & EGUID_GENTYPE_BIGMASK){
		format[3] = 'X';
	}
	printf("0%c", (((opt & EGUID_GENTYPE_XSMALL) == 0) && (opt & (EGUID_GENTYPE_BIGMASK | EGUID_GENTYPE_XBIG))) ? 'X' : 'x');
	printf(format, (DWORD)(val >> 32));
	printf(format, (DWORD)(val));
	printf((((opt & EGUID_GENTYPE_ULLSMALL) == 0) &&
		(opt & (EGUID_GENTYPE_BIGMASK | EGUID_GENTYPE_ULLBIG))) ? "ULL" : "ull");
}

/*!
	@brief	R}hCo̓IvVtOl\܂B
	@param	argc	[in]	main ֐ɓnꂽlB
	@param	argv	[in]	main ֐ɓnꂽlB
	@param	repeat	[io]	̌JԂ񐔁B
	@return	o̓IvVtOlB
*/
static DWORD readParam( int argc, char* argv[], int* repeat ){
	DWORD flag = 0;
	int i;

	*repeat = 1;
	for(i = 1;i < argc;++i){
		if(argv[i][0] == '-' && strlen(argv[i]) == 2){
			switch(argv[i][1]){
				case 'g': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_STRING;  break;
				case 's': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_SSTRUCT; break;
				case 'q': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_S64BITS; break;
				case 'd': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_S32BITS; break;
				case 'w': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_S16BITS; break;
				case 'b': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_S8BITS;  break;
				case 'S': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_USTRUCT; break;
				case 'Q': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_U64BITS; break;
				case 'D': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_U32BITS; break;
				case 'W': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_U16BITS; break;
				case 'B': flag = (flag & (~EGUID_GENTYPE_GENMASK)) | EGUID_GENTYPE_U8BITS;  break;

				case 'n': flag = (flag & (~EGUID_GENTYPE_SPACEMASK)) | EGUID_GENTYPE_INSPACE; break;
				case 'N': flag = (flag & (~EGUID_GENTYPE_SPACEMASK)) | EGUID_GENTYPE_NOSPACE; break;

				case 'x': flag = (flag & (~EGUID_GENTYPE_XMASK)) | EGUID_GENTYPE_XSMALL; break;
				case 'X': flag = (flag & (~EGUID_GENTYPE_XMASK)) | EGUID_GENTYPE_XBIG;   break;
				case 'h': flag = (flag & (~EGUID_GENTYPE_XMASK)) | EGUID_GENTYPE_XOPT;   break;

				case 'l': flag = (flag & (~EGUID_GENTYPE_ULLMASK)) | EGUID_GENTYPE_ULLSMALL; break;
				case 'L': flag = (flag & (~EGUID_GENTYPE_ULLMASK)) | EGUID_GENTYPE_ULLBIG;   break;
				case 'k': flag = (flag & (~EGUID_GENTYPE_ULLMASK)) | EGUID_GENTYPE_ULLOPT;   break;

				default:
					return EGUID_GENTYPE_ERROR;
			}
		}
		else{
			*repeat = atoi(argv[i]);
			if(*repeat <= 0){
				return EGUID_GENTYPE_ERROR;
			}
		}
	}
	return flag;
}

/*!
	@brief	GUID lo
	@param	flag	[in]	o̓tOB
*/
static int printGuid( DWORD flag ){
	wchar_t	buffer[256];
	U		u;
	int		i;

	const char* block_begin;
	const char* colon;
	const char* block_end;

	if(flag & EGUID_GENTYPE_NOSPACE){
		block_begin			= "{";
		colon				= ",";
		block_end			= "}";
	}
	else{
		block_begin			= "{ ";
		colon				= ", ";
		block_end			= " }";
	}

	if(FAILED(CoCreateGuid(&u.guid))) return -1;

	switch(flag & EGUID_GENTYPE_GENMASK){
		case EGUID_GENTYPE_STRING:
			StringFromGUID2(&u.guid, buffer, 256);
			printf(OLESTR_PRINT_FORMAT, buffer);
			return 0;
		case EGUID_GENTYPE_SSTRUCT:
		case EGUID_GENTYPE_USTRUCT:
			printf(block_begin);
			printHex(u.guid.Data1, 8, flag); printf(colon);
			printHex(u.guid.Data2, 4, flag); printf(colon);
			printHex(u.guid.Data3, 4, flag); printf(colon);
			printf(block_begin);
			i = 0;
			do{
				printHex(u.guid.Data4[i], 2, flag);
				if(++i < 8) printf(colon);
			} while(i < 8);
			printf(block_end);
			printf(block_end);
			return 0;
		case EGUID_GENTYPE_S64BITS:
		case EGUID_GENTYPE_U64BITS:
			printf(block_begin);
			printHex64(u.byte64[0], flag); printf(colon);
			printHex64(u.byte64[1], flag);
			printf(block_end);
			return 0;
		case EGUID_GENTYPE_S32BITS:
		case EGUID_GENTYPE_U32BITS:
			printf(block_begin);
			i = 0;
			do{
				printHex(u.byte32[i], 8, flag);
				if(++i < 4) printf(colon);
			} while(i < 4);
			printf(block_end);
			return 0;
		case EGUID_GENTYPE_S16BITS:
		case EGUID_GENTYPE_U16BITS:
			printf(block_begin);
			i = 0;
			do{
				printHex(u.byte16[i], 4, flag);
				if(++i < 8) printf(colon);
			} while(i < 8);
			printf(block_end);
			return 0;
		case EGUID_GENTYPE_S8BITS:
		case EGUID_GENTYPE_U8BITS:
			printf(block_begin);
			i = 0;
			do{
				printHex(u.byte8[i], 2, flag);
				if(++i < 16) printf(colon);
			} while(i < 16);
			printf(block_end);
			return 0;
	}
	return -1;
}

/*!
	@brief C֐B
*/
int main( int argc, char* argv[] ){
	int		repeat;
	DWORD	flag = readParam(argc, argv, &repeat);

	if(flag & EGUID_GENTYPE_ERROR){
		return -1;
	}

loop:
	if(printGuid(flag) != 0) return -1;
	--repeat;
	if(repeat > 0){
		printf("\n");
		goto loop;
	}

	return 0;
}
