/*!
 * @file	cmndbg.h
 * @author	Mitsunagi Studio
 * @version	1.04
 */
#pragma once

#include <crtdbg.h>
#include <stdarg.h>

#include "c_extern_in.h"

void __cdecl debugf( const char* format, ... );
void __cdecl wdebugf( const wchar_t* format, ... );
void __fastcall vdebugf( const char* format, va_list va );
void __fastcall vwdebugf( const wchar_t* format, va_list va );

#include "c_extern_out.h"

#ifdef _DEBUG

#include <stdio.h>

#define SET_MEMDEBUG() _CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF)

#ifdef _CRTDBG_MAP_ALLOC

#ifdef __cplusplus
#include <cstdlib>
#include <new>
#include <memory>

#ifdef USE_CAPITAL_NEW
#define NEW  ::new(_NORMAL_BLOCK, __FILE__, __LINE__)
#else /* USE_CAPITAL_NEW */
#define new  ::new(_NORMAL_BLOCK, __FILE__, __LINE__)
#endif /* USE_CAPITAL_NEW */

#endif /* __cplusplus */

#endif /* _CRTDBG_MAP_ALLOC */

//! _ASSERT_EXPR ̉ψ
#define _ASSERT_EXPR2(expr, msg, ...) \
        (void) ((!!(expr)) || \
                (1 != _CrtDbgReportW(_CRT_ASSERT, _CRT_WIDE(__FILE__), __LINE__, NULL, msg, __VA_ARGS__)) || \
                (_CrtDbgBreak(), 0))

//! AT[g̃bZ[W
#define _ASSERTMES(msg, ...) \
        (void) ((1 != _CrtDbgReportW(_CRT_ASSERT, _CRT_WIDE(__FILE__), __LINE__, NULL, msg, __VA_ARGS__)) || \
                (_CrtDbgBreak(), 0))

//! fobO`FbN^CṽAT[gB
#define _ASSERTE_CHECK(X) _ASSERTE(X)
//! fobO`FbN^CṽAT[gB
#define _ASSERT_CHECK(X) _ASSERT(X)

#else /* _DEBUG */

#define SET_MEMDEBUG() ((void)0)

#ifdef USE_CAPITAL_NEW
#define NEW  new
#endif /* USE_CAPITAL_NEW */
#define STATIC_ASSERT(expr)
#define _ASSERT_EXPR2(expr, msg, ...) ((void)0)
#define _ASSERTMES(msg, ...)((void)0)

#define _ASSERTE_CHECK(X) X
#define _ASSERT_CHECK(X) X

#endif /* _DEBUG */
