/*!
 * @file	TaskTray.c
 * @author	Mitsunagi Studio
 * @version	1.04
 */
#include "stdafx.h"
#include "TaskTray.h"
#include "resource.h"
#include "Flipboard.h"

#define RETRY_COUNT 32

static NOTIFYICONDATA	sTaskTrayNotify;
static HICON			sTaskTrayIcons[ETTI_NUM];
static LPCWSTR			sTaskTrayTexts[ETTI_NUM] = {
	L"off",
	L"FIFO (coping)",
	L"FIFO (pasting)",
	L"Loop (coping)",
	L"Loop (pasting)",
};

static ETaskTrayState	sTaskTrayNowState;

void __fastcall update_tip_text( WCHAR buffer[128], LPCWSTR state )
{
	swprintf_s(buffer, 128, L"%s%s%s", FLIPBOARD_NAME L" - ", state, gIsLineMode ? L" [Line division]" : L"");
}


BOOL __fastcall TaskTrayInit( void )
{
	DWORD err;
	DWORD retry = RETRY_COUNT;
	NOTIFYICONDATA* notify = &sTaskTrayNotify;

	sTaskTrayIcons[ETTI_OFF]		= FBLoadIcon(IDI_TT_NORMAL);
	sTaskTrayIcons[ETTI_FIFO_COPY]	= FBLoadIcon(IDI_TT_FIFO_C);	
	sTaskTrayIcons[ETTI_FIFO_PASTE]	= FBLoadIcon(IDI_TT_FIFO_P);
	sTaskTrayIcons[ETTI_LOOP_COPY]	= FBLoadIcon(IDI_TT_LOOP_C);
	sTaskTrayIcons[ETTI_LOOP_PASTE]	= FBLoadIcon(IDI_TT_LOOP_P);

	do
	{
		BOOL result;
		notify->cbSize				= sizeof(NOTIFYICONDATA);
		notify->hWnd				= gHWnd;
		notify->uID					= 0;
		notify->uFlags				= NIF_ICON | NIF_MESSAGE | NIF_TIP;
		notify->uCallbackMessage	= WM_USER_TASKTRAY;
		notify->hIcon				= sTaskTrayIcons[ETTI_OFF];
		notify->uTimeout			= 5000;
		update_tip_text(notify->szTip, sTaskTrayTexts[ETTI_OFF]);

		if (retry != RETRY_COUNT)
		{
			Sleep(1000);
			result = (Shell_NotifyIcon(NIM_MODIFY, notify) || Shell_NotifyIcon(NIM_ADD, notify));
		}
		else
		{
			result = (Shell_NotifyIcon(NIM_ADD, notify) != FALSE);
		}
		if (result) {
			return TRUE;
		}
		err = GetLastError();
	} while ((err == ERROR_TIMEOUT || err == ERROR_NO_TOKEN) && --retry > 0);

	notify->cbSize = 0;
	debugf("VFo^G[(%d)\n", err);
	return FALSE;
}
void __fastcall TaskTrayChangeState( ETaskTrayState inState )
{
	sTaskTrayNotify.hIcon = sTaskTrayIcons[inState];
	update_tip_text(sTaskTrayNotify.szTip, sTaskTrayTexts[inState]);
	Shell_NotifyIcon(NIM_MODIFY, &sTaskTrayNotify);
	sTaskTrayNowState = inState;
}
void __fastcall TaskTrayUpdateText( void )
{
	update_tip_text(sTaskTrayNotify.szTip, sTaskTrayTexts[sTaskTrayNowState]);
	Shell_NotifyIcon(NIM_MODIFY, &sTaskTrayNotify);
}

void __fastcall TaskTrayTerm( void )
{
	if (sTaskTrayNotify.cbSize != 0) { Shell_NotifyIcon(NIM_DELETE, &sTaskTrayNotify); }
}
