/*!
 * @file	ClipText.c
 * @author	Mitsunagi Studio
 * @version	1.04
 */
#include "stdafx.h"
#include "ClipText.h"
#include "Flipboard.h"

typedef struct SClipData_ {
	SText*				mPtr;
	struct SClipData_*	mNext;
	struct SClipData_*	mPrev;

} SClipData;

typedef struct SClipHist_ {
	SClipData		mRoot;
	UINT			mCount;
	UINT			mIDCur;
	HMENU			mMenu;
	HFONT			mMenuFont;
	MENUITEMINFO	mMii;
} SClipHist;


static SClipData	sRoot;
static SClipData*	sCurrent;

static SClipHist	sClipHist;

static SMenuItemData	sMenuItemData[TESTHIST_COUNT];

static SClipData* __fastcall clipdata_new( SText* inText )
{
	SClipData* cd = (SClipData*)malloc(sizeof(SClipData));
	if (cd != NULL)
	{
//		cd->mNext = cd->mPrev = cd;
		cd->mPtr = TextAddRef(inText);
	}
	return cd;
}

static void __fastcall clipdata_free( SClipData* inClipData )
{
	TextRelease(&inClipData->mPtr);
	free(inClipData);
}

void __fastcall ClipTextReset( void )
{
	if (sRoot.mNext != NULL)
	{
		SClipData* cur = sRoot.mNext;
		SClipData* tmp;
		while (cur != &sRoot)
		{
			tmp = cur;
			cur = cur->mNext;
			clipdata_free(tmp);
		}
	}
	sRoot.mNext = sRoot.mPrev = &sRoot;
	sCurrent = NULL;
}
BOOL __fastcall ClipTextIsEmpty( void )
{
	return (sRoot.mNext == &sRoot);
}
BOOL __fastcall ClipTextPush( SText* inText )
{
	SClipData* cd = clipdata_new(inText);
	if (cd != NULL)
	{
		cd->mNext = &sRoot;
		cd->mPrev = sRoot.mPrev;
		sRoot.mPrev->mNext = cd;
		sRoot.mPrev = cd;
		if (sCurrent == NULL) { sCurrent = cd; }
	}
	return (cd != NULL);
}
BOOL __fastcall ClipTextPop( void )
{
	SClipData* cd;
	if (sRoot.mNext == &sRoot) { return FALSE; }
	cd = sRoot.mNext;
	cd->mNext->mPrev = cd->mPrev;
	cd->mPrev->mNext = cd->mNext;
	clipdata_free(cd);
	return TRUE;
}
BOOL __fastcall ClipTextNext( SText** outText )
{
	if (sCurrent == NULL) { return FALSE; }
	sCurrent = sCurrent->mNext;
	if (sCurrent == &sRoot) { sCurrent = sCurrent->mNext; }
	*outText = TextAddRef(sCurrent->mPtr);
	return TRUE;
}
BOOL __fastcall ClipTextCurrent( SText** outText )
{
	TextRelease(outText);
	if (sCurrent == NULL) { return FALSE; }
	*outText = TextAddRef(sCurrent->mPtr);
	return TRUE;
}
BOOL __fastcall ClipTextTop( SText** outText )
{
	TextRelease(outText);
	if (sRoot.mNext == &sRoot) { return FALSE; }
	*outText = TextAddRef(sRoot.mNext->mPtr);
	return TRUE;
}
BOOL __fastcall ClipTextResetCurrent( void )
{
	if (sRoot.mNext == &sRoot) { return FALSE; }
	sCurrent = sRoot.mNext;
	return TRUE;
}

BOOL __fastcall ClipHistInit( void )
{
	SClipHist* ch = &sClipHist;

	ch->mMenu = CreatePopupMenu();
	if (ch->mMenu != NULL)
	{
		NONCLIENTMETRICS ncm = { sizeof(NONCLIENTMETRICS), };

		if (SystemParametersInfo( SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICS), &ncm, 0 ))
		{
			ch->mMenuFont = CreateFontIndirect(&ncm.lfMenuFont);
			if (ch->mMenuFont != NULL)
			{
				ch->mMii.cbSize		= sizeof(MENUITEMINFO);
				ch->mMii.fMask		= MIIM_ID | MIIM_STRING | MIIM_DATA | MIIM_FTYPE;
				ch->mMii.dwItemData	= 0;
				ch->mMii.fType		= MFT_OWNERDRAW;
				ch->mMii.fState		= 0;//MFS_UNHILITE;
				ch->mMii.cch		= 0;

				ch->mRoot.mNext = ch->mRoot.mPrev = &ch->mRoot;

				return TRUE;
			}
		}

	}
	return FALSE;
}
void __fastcall ClipHistTerm( void )
{
	ClipHistReset();
	if (sClipHist.mMenu) { DestroyMenu(sClipHist.mMenu); }
}
BOOL __fastcall ClipHistIsEmpty( void )
{
	return (sClipHist.mRoot.mNext == &sClipHist.mRoot);
}

void __fastcall ClipHistReset( void )
{
	SClipData* root = &sClipHist.mRoot;
	SClipData* cur = root->mNext;
	SClipData* tmp;
	int i, count = GetMenuItemCount(sClipHist.mMenu);

	while (cur != root)
	{
		tmp = cur;
		cur = cur->mNext;
		clipdata_free(tmp);
	}
	sClipHist.mCount = 0;
	for (i = 0;i < count;++i)
	{
		RemoveMenu(sClipHist.mMenu, 0, MF_BYPOSITION);
	}
}
BOOL __fastcall ClipHistAdd( SText* inText )
{
	SClipHist*		ch = &sClipHist;
	MENUITEMINFO	mii = { sizeof(MENUITEMINFO), };
	wchar_t			buffer[8] = L"&1";
	SClipData*		cp = clipdata_new(inText);
	UINT			i;
	SMenuItemData*	mid = sMenuItemData + ch->mIDCur;

	if (cp == NULL) { return FALSE; }

	cp->mNext = &ch->mRoot;
	cp->mPrev = ch->mRoot.mPrev;
	ch->mRoot.mPrev->mNext = cp;
	ch->mRoot.mPrev = cp;

	mid->mText = cp->mPtr;
	memcpy(mid->mItemText, mid->mText->mData, min(mid->mText->mSize, sizeof(mid->mItemText) - 2));
	mid->mItemText[sizeof(mid->mItemText) - 2] = mid->mItemText[sizeof(mid->mItemText) - 1] = 0;

	ch->mMii.dwTypeData	= buffer;
	ch->mMii.wID		= IDM_POPUP_HISBASE + ch->mIDCur;
	ch->mMii.dwItemData	= (ULONG_PTR)mid;
	ch->mIDCur			= (ch->mIDCur + 1) % TESTHIST_COUNT;

	InsertMenuItem(ch->mMenu, 0, TRUE, &ch->mMii);
	if (ch->mCount < TESTHIST_COUNT) { ++ch->mCount; }
	else { RemoveMenu(ch->mMenu, ch->mCount, MF_BYPOSITION); }

	for (i = 1;i < ch->mCount && i < (TESTHIST_COUNT + 1);++i)
	{
		mii.fMask		= MIIM_ID | MIIM_STRING;
		mii.cch			= 8;
		mii.dwTypeData	= buffer;
		if (GetMenuItemInfo(ch->mMenu, i, TRUE, &mii) && mii.dwTypeData != NULL)
		{
			if (i < 9) { mii.dwTypeData[1] = L'1' + i; }
			else if (i < 36) { mii.dwTypeData[1] = L'A' + (i - 9); }
			else { mii.dwTypeData[0] = mii.dwTypeData[1] = L' '; }
			SetMenuItemInfo(ch->mMenu, i, TRUE, &mii);
		}
	}

	return TRUE;
}
BOOL __fastcall ClipHistGet( UINT inIdx, SText** outText )
{
	SClipData* cp;
	if (inIdx >= sClipHist.mCount) { return FALSE; }

	for (cp = sClipHist.mRoot.mNext;inIdx > 0;--inIdx) { cp = cp->mNext; }
	*outText = cp->mPtr;
	return TRUE;
}
HMENU __fastcall ClipHistGetMenu( void )
{
	return sClipHist.mMenu;
}

BOOL __fastcall GetClipData( SText** outText )
{
	LPVOID		data;
	size_t		size;
	HGLOBAL		hGlobal;
	BOOL		isAText = IsClipboardFormatAvailable(CF_TEXT);
	BOOL		isUText = IsClipboardFormatAvailable(CF_UNICODETEXT);
	SText*		text;

	if ((!isAText && !isUText) || !OpenClipboard(gHWnd)) { return FALSE; }

	hGlobal = (HGLOBAL)GetClipboardData(isUText ? CF_UNICODETEXT : CF_TEXT);
	if (hGlobal == NULL)
	{
		CloseClipboard();
		return FALSE;
	}
	data = GlobalLock(hGlobal);

	size = isUText ? ((wcslen((LPCWSTR)data) + 1) << 1) : (strlen((LPCSTR)data) + 1);

	text = TextNew(data, size, isUText);
	TextRelease(outText);
	*outText = ((text != NULL) ? text : NULL);

	GlobalUnlock(hGlobal);
	CloseClipboard();

	return (text != NULL);
}
BOOL __fastcall SetClipData( SText* inText )
{
	LPVOID	data;
	HGLOBAL	hGlobal;

	if (inText == NULL) { return FALSE; }

	hGlobal = GlobalAlloc(GHND, inText->mSize);
	if (hGlobal == NULL) { return FALSE; }

	data = GlobalLock(hGlobal);
	memcpy(data, inText->mData, inText->mSize);
	GlobalUnlock(hGlobal);

	if (!OpenClipboard(gHWnd))
	{
		GlobalFree(hGlobal);
		return FALSE;
	}
	EmptyClipboard();
	SetClipboardData(inText->mIsUnicode ? CF_UNICODETEXT : CF_TEXT, hGlobal);
	CloseClipboard();
	return TRUE;
}

