/*!
 * @file	ToolTip.c
 * @author	Mitsunagi Studio
 * @version	1.04
 */
#include "stdafx.h"
#include "ToolTip.h"
#include "Flipboard.h"

SToolTip gSToolTip;

BOOL __fastcall ToolTipInit( UINT inToolTipId, int inMaxWidth )
{
	TOOLINFO ti = { sizeof(TOOLINFO), TTF_TRACK, gHWnd, inToolTipId, };
	HWND tt = CreateWindowEx(WS_EX_TOOLWINDOW,
		TOOLTIPS_CLASS, NULL, WS_POPUP | TTS_ALWAYSTIP | TTS_NOPREFIX,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		NULL, NULL, gHInstance, NULL);

	if (tt == NULL) { return FALSE; }
	SetWindowPos(tt, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);

	SendMessage(tt, TTM_ADDTOOL, 0, (LPARAM)&ti);
	SendMessage(tt, TTM_SETMAXTIPWIDTH, 0, inMaxWidth);

	ZeroMemory(&gSToolTip, sizeof(SToolTip));
	gSToolTip.mToolTip = tt;
	return TRUE;
}
void __fastcall ToolTipTerm( void )
{
	if (gSToolTip.mToolTip != NULL)
	{
		DestroyWindow(gSToolTip.mToolTip);
		gSToolTip.mToolTip = NULL;
	}
}
void __fastcall ToolTipSetTextA( LPCSTR inText )
{
	TOOLINFOA ti = { sizeof(TOOLINFOA), 0, gHWnd, 0, };
	ti.lpszText = (LPSTR)inText;
	SendMessage(gSToolTip.mToolTip, TTM_UPDATETIPTEXTA, 0, (LPARAM)&ti);
	gSToolTip.mText				= inText;
	gSToolTip.mTextIsUnicode	= TRUE;
}
void __fastcall ToolTipSetTextW( LPCWSTR inText )
{
	TOOLINFOW ti = { sizeof(TOOLINFOW), 0, gHWnd, 0, };
	ti.lpszText = (LPWSTR)inText;
	SendMessage(gSToolTip.mToolTip, TTM_UPDATETIPTEXTW, 0, (LPARAM)&ti);
	gSToolTip.mText				= inText;
	gSToolTip.mTextIsUnicode	= TRUE;
}
/*
void __fastcall ToolTipSetTitleA( LPCSTR inTitle )
{
	SendMessage(gSToolTip.mToolTip, TTM_SETTITLEA, 0, (LPARAM)inTitle);
	gSToolTip.mTitle			= inTitle;
	gSToolTip.mTitleIsUnicode	= TRUE;
}
void __fastcall ToolTipSetTitleW( LPCWSTR inTitle )
{
	SendMessage(gSToolTip.mToolTip, TTM_SETTITLEW, 0, (LPARAM)inTitle);
	gSToolTip.mTitle			= inTitle;
	gSToolTip.mTitleIsUnicode	= TRUE;
}
*/
void __fastcall ToolTipShow( int inX, int inY )
{
	TOOLINFO ti = { sizeof(TOOLINFO), 0, gHWnd, 0 };
	HWND tt = gSToolTip.mToolTip;
	ShowWindow(tt, SW_HIDE);

	SendMessage(tt, TTM_TRACKACTIVATE, FALSE,	(LPARAM)&ti);
	SendMessage(tt, TTM_TRACKPOSITION, 0,		MAKELPARAM(inX, inY));
	SendMessage(tt, TTM_TRACKACTIVATE, TRUE,	(LPARAM)&ti);
}
void __fastcall ToolTipHide( void )
{
	TOOLINFO ti = { sizeof(TOOLINFO), 0, gHWnd, 0 };
	ShowWindow(gSToolTip.mToolTip, SW_HIDE);
	SendMessage(gSToolTip.mToolTip, TTM_TRACKACTIVATE, FALSE, (LPARAM)&ti);
}
