/*!
 * @file	Text.c
 * @author	Mitsunagi Studio
 * @version	1.04
 */
#include "stdafx.h"
#include "Text.h"
#include "Flipboard.h"

//#define DEBUG_REF_LOG

SText* __fastcall TextNew( LPCVOID inText, size_t inLength, BOOL isUnicode )
{
	SText* text;

	text = (SText*)malloc(offsetof(SText, mData) + inLength);
	if (text != NULL)
	{
		size_t cpysize = inLength - (1 << isUnicode);
		text->mRefCount = 1;
		text->mIsUnicode = isUnicode;
		text->mSize = inLength;
		memcpy(text->mData, inText, cpysize);
		memset((BYTE*)text->mData + cpysize, 0, (1 << isUnicode));
	}
	return text;
}
SText* __fastcall TextAddRef( SText* inText )
{
#if defined(_DEBUG) && defined(DEBUG_REF_LOG)
	long c = InterlockedIncrement(&inText->mRefCount);
	if (inText->mIsUnicode) { wdebugf(L"text_add: (%d)[%s]\n", c ,inText->mData); }
	else { debugf("text_add: (%d)[%s]\n", c, inText->mData); }
#else
	InterlockedIncrement(&inText->mRefCount);
#endif
	return inText;
}
void __fastcall TextRelease( SText** inText )
{
	SText* p = *inText;
	long c;
	if (p != NULL)
	{
		_ASSERT(p->mRefCount > 0);
		c = InterlockedDecrement(&p->mRefCount);
#if defined(_DEBUG) && defined(DEBUG_REF_LOG)
		if (p->mIsUnicode) { wdebugf(L"text_rel: (%d)[%s]\n", c ,p->mData); }
		else { debugf("text_rel: (%d)[%s]\n", c, p->mData); }
#endif
		if (c == 0)
		{
			free(p);
		}
		*inText = NULL;
	}
}

LPCVOID __fastcall TextGetLineA( LPCSTR inText, SText** outText )
{
	LPCSTR begin;

	while (*inText != '\0' && (*inText == '\r' || *inText == '\n')) { ++inText; }
	if (*inText == '\0') { return NULL; }
	begin = inText;
	while (*inText != '\0' && (*inText != '\r' && *inText != '\n')) { ++inText; }

	*outText = TextNew(begin, (inText - begin) + 1, FALSE);
	return inText;
}
LPCVOID __fastcall TextGetLineW( LPCWSTR inText, SText** outText )
{
	LPCWSTR begin;

	while (*inText != L'\0' && (*inText == L'\r' || *inText == L'\n')) { ++inText; }
	if (*inText == L'\0') { return NULL; }
	begin = inText;
	while (*inText != L'\0' && (*inText != L'\r' && *inText != L'\n')) { ++inText; }

	*outText = TextNew(begin, ((inText - begin) + 1) << 1, TRUE);
	return inText;
}

LPCVOID __fastcall TextGetLine( LPCVOID inText, SText** outText, BOOL isUnicode )
{
	TextRelease(outText);
	return (isUnicode ? TextGetLineW(inText, outText) : TextGetLineA(inText, outText)); 
}
