/*!
 * @file	Font.c
 * @author	Mitsunagi Studio
 * @version	1.04
 */
#include "stdafx.h"
#include "Font.h"
#include "Flipboard.h"

SFont	gMenuFont;

BOOL __fastcall FontInit( LPCWSTR inName, int inWidth )
{
	HFONT font = CreateFont(inWidth, 0, 0, 0,
			FW_REGULAR, FALSE, FALSE, FALSE,
			SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
			PROOF_QUALITY, DEFAULT_PITCH, inName);
	if (font != NULL)
	{
		HDC dc = GetDC(NULL);
		HGDIOBJ old = SelectObject(dc, font);
		GetTextMetrics(dc, &gMenuFont.mMetric);
		SelectObject(dc, old);
		ReleaseDC(NULL, dc);
		gMenuFont.mFont = font;
	}
	return (font != NULL);
}
void __fastcall FontTerm( void )
{
	if (gMenuFont.mFont != NULL)
	{
		DeleteObject(gMenuFont.mFont);
	}
}
