/*!
 * @file	Setting.c
 * @author	Mitsunagi Studio
 * @version	1.04
 */
#include "stdafx.h"
#include "setting.h"
#include "resource.h"

#define SETTING_FILE "setting.dat"

SSettingStruct gSetting;

static WNDPROC			gEditProc;
static SSettingStruct	gHotKeySetting;
static DWORD			gModFlag;
static HHOOK			gHDlg_Hook;

void __fastcall SettingInit( void )
{
	FILE* fp = NULL;
	if (fopen_s(&fp, SETTING_FILE, "rb") != 0 ||
		fread(&gSetting, sizeof(SSettingStruct), 1, fp) != 1)
	{
		gSetting.mFIFO_Virt	= MOD_ALT;
		gSetting.mFIFO_Key	= VK_CONVERT;
		gSetting.mLoop_Virt	= MOD_CONTROL;
		gSetting.mLoop_Key	= VK_CONVERT;
		gSetting.mMenu_Virt	= MOD_ALT;
		gSetting.mMenu_Key	= VK_NONCONVERT;
		gSetting.mLine_Virt	= MOD_CONTROL;
		gSetting.mLine_Key	= VK_OEM_COPY;
	}
	if (fp) { fclose(fp); }
}

void __fastcall SettingTerm( void )
{
	FILE* fp;
	if (fopen_s(&fp, SETTING_FILE, "wb") == 0)
	{
		fwrite(&gSetting, sizeof(SSettingStruct), 1, fp);
		fclose(fp);
	}
}

static LRESULT CALLBACK HotKeyProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	if (msg == WM_SETFOCUS)
	{
		gModFlag = 0;
	}
	else if (msg == WM_KILLFOCUS)
	{
		if (gModFlag & 0x80000000)
		{
			SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)L"Ȃ");
		}
		gModFlag = 0;
	}
	return gEditProc(hWnd, msg, wParam, lParam);
}

void __fastcall CheckModifireKey( DWORD* virt, UINT shift, LPARAM lParam )
{
	DWORD v = *virt;
	UINT f = (((lParam >> 24) & 1) + 1) << shift;
	if ((lParam & 0x80000000) == 0) { v = (v & 0x7fffffff) | f; }
	else { v &= ~f; }
	*virt = v;
}

static BOOL __fastcall UpdateHotKeyTextL( HWND hWnd, BYTE virt, LPARAM lParam ){
	wchar_t value[128];
	BOOL r = GetHotKeyValue2(value, virt, lParam);
	SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)value);
	return (r != 0);
}
static BOOL __fastcall UpdateHotKeyText( HWND hDlg, UINT id, BYTE virt, WORD key )
{
	HWND hWnd = GetDlgItem(hDlg, id);
	return (hWnd != NULL) ? UpdateHotKeyTextL(hWnd, virt, (MapVirtualKey(key, 0) << 16)) : FALSE;
}

LRESULT CALLBACK KeyHookProc( int nCode, WPARAM wParam, LPARAM lParam )
{
	static LPARAM prev = 0;

	if (nCode == HC_ACTION)
	{
		SSettingStruct* hks = &gHotKeySetting;
		HWND hWnd	= GetFocus();
		HWND hDlg	= GetParent(hWnd);
		HWND hWFifo	= GetDlgItem(hDlg, IDC_HOTKEY_FIFO);
		HWND hWLoop	= GetDlgItem(hDlg, IDC_HOTKEY_LOOP);
		HWND hWMenu	= GetDlgItem(hDlg, IDC_HOTKEY_MENU);
		HWND hWLine	= GetDlgItem(hDlg, IDC_HOTKEY_LINE);

		if (hWFifo != NULL && hWLoop != NULL && hWMenu != NULL && (hWnd == hWFifo || hWnd == hWLoop || hWnd == hWMenu || hWnd == hWLine))
		{
			BOOL	isMod = TRUE;
			BYTE*	mod;
			WORD*	key;
			DWORD	modFlag = gModFlag;

			if (prev == lParam) { return TRUE; }
			prev = lParam;

			if (hWnd == hWFifo)				{ mod = &hks->mFIFO_Virt; key = &hks->mFIFO_Key; }
			else if (hWnd == hWLoop)		{ mod = &hks->mLoop_Virt; key = &hks->mLoop_Key; }
			else if (hWnd == hWMenu)		{ mod = &hks->mMenu_Virt; key = &hks->mMenu_Key; }
			else/* if (hWnd == hWLine)*/	{ mod = &hks->mLine_Virt; key = &hks->mLine_Key; }

			if (VK_SHIFT <= wParam && wParam <= VK_MENU) { CheckModifireKey(&gModFlag, (wParam & 0x0f) << 1, lParam); }
			else { isMod = FALSE; }

			if ((modFlag & 0x80000000) == 0)
			{
				BYTE virt = ((modFlag & 0x03) ? MOD_SHIFT : 0) |
					((modFlag & 0x0c) ? MOD_CONTROL : 0) |
					((modFlag & 0x30) ? MOD_ALT : 0);
				if (UpdateHotKeyTextL(hWnd, virt, (isMod ? 0 : lParam)))
				{
					*mod = virt;
					*key = MapVirtualKey((lParam >> 16) & 0xff, 1);
					gModFlag |= 0x80000000;
				}
				else
				{
					*mod = 0;
					*key = 0;
				}
			}
			return TRUE;
		}
	}
	return CallNextHookEx(gHDlg_Hook, nCode, wParam, lParam);
}

INT_PTR CALLBACK SettingDlg( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	WORD hwParam = LOWORD(wParam);

	UNREFERENCED_PARAMETER(lParam);
	if (message == WM_INITDIALOG)
	{
		// tbNo^
		gHotKeySetting = gSetting;
		gHDlg_Hook = SetWindowsHookEx(WH_KEYBOARD, KeyHookProc, NULL, GetCurrentThreadId());
		UpdateHotKeyText(hDlg, IDC_HOTKEY_FIFO, gHotKeySetting.mFIFO_Virt, gHotKeySetting.mFIFO_Key);
		UpdateHotKeyText(hDlg, IDC_HOTKEY_LOOP, gHotKeySetting.mLoop_Virt, gHotKeySetting.mLoop_Key);
		UpdateHotKeyText(hDlg, IDC_HOTKEY_MENU, gHotKeySetting.mMenu_Virt, gHotKeySetting.mMenu_Key);
		UpdateHotKeyText(hDlg, IDC_HOTKEY_LINE, gHotKeySetting.mLine_Virt, gHotKeySetting.mLine_Key);
		return (gHDlg_Hook != NULL);
	}
	else if (message == WM_CLOSE)
	{
		EndDialog(hDlg, hwParam);
		return TRUE;
	}
	else if (message == WM_COMMAND)
	{
		switch (hwParam)
		{
			case ID_OK:
				gSetting = gHotKeySetting;
			case ID_CANCEL:
				EndDialog(hDlg, hwParam);
				return TRUE;
		}
	}
	else if (message == WM_DESTROY) {
		// tbNo^
		UnhookWindowsHookEx(gHDlg_Hook);
	}

	return FALSE;
}

static void __fastcall wcscat_s_bias( LPWSTR ioBuffer, LPCWSTR inText )
{
	wcscat_s(ioBuffer, 128, inText);
}

BOOL __cdecl GetHotKeyValue2( wchar_t outBuffer[HOTKEY_STRING_MAX], BYTE virt, LPARAM lParam )
{
	wchar_t keyname[32];
	int r = 0;

	outBuffer[0] = L'\0';
	if (virt != 0)
	{
		if (virt & MOD_SHIFT)	{ wcscat_s_bias(outBuffer, L"Shift + "); }
		if (virt & MOD_CONTROL)	{ wcscat_s_bias(outBuffer, L"Ctrl + "); }
		if (virt & MOD_ALT)		{ wcscat_s_bias(outBuffer, L"Alt + "); }
		if ((r = GetKeyNameText(lParam | (1 << 25), keyname, 32)) != 0)
		{
			wcscat_s_bias(outBuffer, keyname);
		}
	}
	if (outBuffer[0] == L'\0') { wcscat_s_bias(outBuffer, L"Ȃ"); }
	return (r != 0);
}
BOOL __cdecl GetHotKeyValue( wchar_t outBuffer[HOTKEY_STRING_MAX], BYTE virt, WORD key )
{
	return GetHotKeyValue2(outBuffer, virt, (MapVirtualKey(key, 0) << 16));
}
