/*!
 * @file	Flipboard.c
 * @author	Mitsunagi Studio
 * @version	1.04
 */
#include "stdafx.h"
#include "Flipboard.h"

#include "TaskTray.h"
#include "HotKey.h"
#include "ClipText.h"
#include "ToolTip.h"
#include "Setting.h"
#include "Font.h"
#include "fifo/fifo.h"
#include "resource.h"

#define WINDOWNAME			L"FlipBoard"

#define CLASSNAME			L"FlipBoard_MS_Class"
#define MUTEXNAME			L"FlipBoard_MS_Mutex"

#define HOTKEY_COUNT		4

#define HOTKEY_HISTORY		2
#define HOTKEY_TOGGLE_FIFO	3
#define HOTKEY_TOGGLE_LOOP	4
#define HOTKEY_TOGGLE_LINE	5
#define HOTKEY_EXIT			6

#define TIMER_ID_COPY		1
#define TIMER_ID_PASTE		2

#define ELAPSE_COPY			80
#define ELAPSE_PASTE		80

#define ERRMES_HOTKEY		L"zbgL[̓o^Ɏs܂B\n" \
							L"̃AvP[VŃzbgL[gpĂ\܂B\n" \
							L"gpĂAvP[V̐ݒ̕ύX͏I邩A\n" \
							L"Flip Board ̐ݒύXĂB"

typedef enum FB_STATE_ {
	FB_STATE_OFF		= 0x0000,
	FB_STATE_FIFO_COPY	= 0x0001,
	FB_STATE_FIFO_PASTE	= 0x0002,
	FB_STATE_LOOP_COPY	= 0x0010,
	FB_STATE_LOOP_PASTE	= 0x0020,

	FB_STATE_FIFO_MASK	= 0x0003,
	FB_STATE_LOOP_MASK	= 0x0030,
} FB_STATE;

typedef struct SFlipBoard_ {
	SToolTip			ToolTip;

	FB_STATE			FIFOState;
	BOOL				IsCtrl;
	BOOL				Processed;

	LPARAM				NowLParam;
	DWORD				DownCtrl;
	HANDLE				Mutex;

	BYTE				MenuTextBuffer[TESTHIST_COUNT][80];

	SHotKey				ToggleFIFO;
	SHotKey				ToggleLoop;
	SHotKey				ShowHistory;
	SHotKey				ToggleLine;
#ifdef _DEBUG
	SHotKey				Exit;
#endif

} SFlipBoard;

SFlipBoard	g;
HWND		gHWnd;
HINSTANCE	gHInstance;
BOOL		gIsLineMode;
HMENU		gPopupMenu;

static void __fastcall warning_hotkey_message( void )
{
	MessageBox(NULL, ERRMES_HOTKEY, L"x", MB_ICONWARNING | MB_APPLMODAL | MB_OK);
}

static void __fastcall check_menu_item( UINT id, BOOL checked )
{
	MENUITEMINFO mii;
	mii.cbSize = sizeof(MENUITEMINFO);
	mii.fMask = MIIM_STATE;
	mii.fState = (checked & 1) << 3;
	SetMenuItemInfo(gPopupMenu, id, FALSE, &mii);
}

static void __fastcall fifo_on( void )
{
	TaskTrayChangeState(ETTI_FIFO_COPY);
	g.FIFOState = FB_STATE_FIFO_COPY;
	g.NowLParam = 0;
	g.DownCtrl = 0;
	ClipTextReset();
	check_menu_item(IDM_POPUP_TOGGLEFIFO, TRUE);
	check_menu_item(IDM_POPUP_TOGGLELOOP, FALSE);
	debugf("Mode FIFO.\n");
}
static void __fastcall loop_on( void )
{
	TaskTrayChangeState(ETTI_LOOP_COPY);
	g.FIFOState = FB_STATE_LOOP_COPY;
	ClipTextResetCurrent();
	g.NowLParam = 0;
	g.DownCtrl = 0;
	ClipTextReset();
	check_menu_item(IDM_POPUP_TOGGLEFIFO, FALSE);
	check_menu_item(IDM_POPUP_TOGGLELOOP, TRUE);
	debugf("Mode Loop.\n");
}
static void __fastcall mode_off( void )
{
	TaskTrayChangeState(ETTI_OFF);
	g.FIFOState = FB_STATE_OFF;
	ClipTextReset();
	check_menu_item(IDM_POPUP_TOGGLEFIFO, FALSE);
	check_menu_item(IDM_POPUP_TOGGLELOOP, FALSE);
	debugf("Mode off.\n");
}

static void __fastcall toggle_fifo( void )
{
	if ((g.FIFOState & FB_STATE_FIFO_MASK) == 0) { fifo_on(); }
	else { mode_off(); }
}

static void __fastcall toggle_loop( void )
{
	BOOL checked = ((g.FIFOState & FB_STATE_LOOP_MASK) == 0);
	if (checked) { loop_on(); }
	else { mode_off(); }
}

static void __fastcall toggle_line( void )
{
	gIsLineMode ^= TRUE;
	check_menu_item(IDM_POPUP_TOGGLELINE, gIsLineMode);
	TaskTrayUpdateText();
}

static void __fastcall set_input_struct( INPUT* in, WORD vk, DWORD flag )
{
	in->type			= INPUT_KEYBOARD;
	in->ki.wVk			= vk;
	in->ki.wScan		= MapVirtualKey(vk, 0);
	in->ki.dwFlags		= flag;
	in->ki.time			= 0;
	in->ki.dwExtraInfo	= 0;
}

static void __fastcall check_hotkey( LPCSTR name, BYTE virt, WORD key )
{
	wchar_t value[128];
	GetHotKeyValue(value, virt, key);
	wdebugf(L"%S: %s(%02x, %04x)\n", name, value, virt, key);
}

static void __fastcall hotkey_on( void )
{
	UINT count = HOTKEY_COUNT;
	check_hotkey("FIFO", gSetting.mFIFO_Virt, gSetting.mFIFO_Key);
	check_hotkey("Loop", gSetting.mLoop_Virt, gSetting.mLoop_Key);
	check_hotkey("Menu", gSetting.mMenu_Virt, gSetting.mMenu_Key);
	check_hotkey("Line", gSetting.mLine_Virt, gSetting.mLine_Key);
	count -= HotKeyInit(&g.ToggleFIFO,	HOTKEY_TOGGLE_FIFO, gSetting.mFIFO_Virt, gSetting.mFIFO_Key);
	count -= HotKeyInit(&g.ToggleLoop,	HOTKEY_TOGGLE_LOOP, gSetting.mLoop_Virt, gSetting.mLoop_Key);
	count -= HotKeyInit(&g.ShowHistory,	HOTKEY_HISTORY,     gSetting.mMenu_Virt, gSetting.mMenu_Key);
	count -= HotKeyInit(&g.ToggleLine,	HOTKEY_TOGGLE_LINE, gSetting.mLine_Virt, gSetting.mLine_Key);
#ifdef _DEBUG
	HotKeyInit(&g.Exit, HOTKEY_EXIT, MOD_SHIFT | MOD_CONTROL, VK_CONVERT);
#endif
	if (count != 0)
	{
		debugf("don't set any hotkey.\n");
#ifndef _DEBUG
		warning_hotkey_message();
#endif
	}
}

static void __fastcall hotkey_off( void ){
	HotKeyTerm(&g.ToggleFIFO);
	HotKeyTerm(&g.ToggleLoop);
	HotKeyTerm(&g.ShowHistory);
	HotKeyTerm(&g.ToggleLine);
#ifdef _DEBUG
	HotKeyTerm(&g.Exit);
#endif
}


static INT_PTR CALLBACK AboutDlg( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	WORD hwParam = LOWORD(wParam);

	UNREFERENCED_PARAMETER(lParam);
	if (message == WM_INITDIALOG) { return TRUE; }
	if (message == WM_COMMAND && (hwParam == IDOK || hwParam == IDCANCEL))
	{
		EndDialog(hDlg, hwParam);
		return TRUE;
	}
	return FALSE;
}

static LPWSTR __stdcall conv_tab_spece_w( LPWSTR buf, size_t size, LPCWSTR text )
{
	LPWSTR end = buf + size - 4;
	LPWSTR ch = buf;
	while (*text != L'\0' && ch < end)
	{
		if (*text == L'\t') { *ch = L' '; }
		else { *ch = *text; }
		++text;
		++ch;
	}
	if (ch == end && (*text != L'\0'))
	{
		ch[0] = ch[1] = ch[2] = L'.';
		ch += 3;
	}
	*ch = L'\0';
	return buf;
}
static LPSTR __stdcall conv_tab_spece_a( LPSTR buf, size_t size, LPCSTR text )
{
	LPSTR end = buf + size - 4;
	LPSTR ch = buf;
	while (*text != '\0' && ch < end)
	{
		if (*text == '\t') { *ch = ' '; }
		else { *ch = *text; }
		++text;
		++ch;
	}
	if (ch == end && (*text != '\0'))
	{
		ch[0] = ch[1] = ch[2] = '.';
		ch += 3;
	}
	*ch = '\0';
	return buf;
}

static void __fastcall show_dialog_box( UINT id, DLGPROC dlgProc )
{
	DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(id), gHWnd, dlgProc);
}
static void __fastcall post_quit_message( void )
{
	PostMessage(gHWnd, WM_QUIT, 0, 0);
}

static HBRUSH __fastcall dc_set_color( HDC dc, int bgColor, int textColor )
{
	SetBkColor(dc, GetSysColor(bgColor));
	SetTextColor(dc, GetSysColor(textColor));
	return (HBRUSH)(bgColor + 1);
}

static void __fastcall set_clip_and_tooltip( SText* inClip, ETaskTrayState inState )
{
	SetClipData(inClip);
	TaskTrayChangeState(inState);
}

static void __stdcall DrawTextAW( BOOL isUnicode, HDC hdc, LPCVOID lpchText, LPRECT lprc, UINT format )
{
	if (isUnicode) { DrawTextW(hdc, (LPCWSTR)lpchText, -1, lprc, format); }
	else { DrawTextA(hdc, (LPCSTR)lpchText, -1, lprc, format); }
}

static LRESULT CALLBACK MainProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	static INPUT	sInput[4];
	static HWND		sHPrev;

	if (hWnd != gHWnd)
	{
		if (msg == WM_CREATE)
		{
			set_input_struct(sInput + 0,	VK_CONTROL,	0);
			set_input_struct(sInput + 1,	'V',		0);
			set_input_struct(sInput + 2,	'V',		KEYEVENTF_KEYUP);
			set_input_struct(sInput + 3,	VK_CONTROL,	KEYEVENTF_KEYUP);
			gPopupMenu = GetSubMenu(LoadMenu(GetModuleHandle(NULL), MAKEINTRESOURCE(IDM_POPUP)), 0);
		}
		else
		{
			debugf("through message: %04X\n", msg);
		}
		return DefWindowProc(hWnd, msg, wParam, lParam);
	}

	switch (msg)
	{
		case WM_DESTROY:
			post_quit_message();
			break;
		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDM_POPUP_TOGGLEFIFO:
					toggle_fifo();
					break;
				case IDM_POPUP_TOGGLELOOP:
					toggle_loop();
					break;
				case IDM_POPUP_TOGGLELINE:
					toggle_line();
					break;
				case IDM_POPUP_SETTING:
					mode_off();
					hotkey_off();
					FIFO_ResetHook();
					show_dialog_box(IDD_SETTING, SettingDlg);
					FIFO_SetHook(hWnd);
					hotkey_on();
					break;
				case IDM_POPUP_VERSION:
					show_dialog_box(IDD_ABOUTBOX, AboutDlg);
					break;
				case IDM_POPUP_EXIT:
					post_quit_message();
					break;
				default:
					if (IDM_POPUP_HISBASE <= LOWORD(wParam))
					{
						HWND			wnd = sHPrev;
						MENUITEMINFO	mii = { sizeof(MENUITEMINFO), };
						SMenuItemData*	mid;

						mii.fMask = MIIM_ID | MIIM_DATA;
						// Nbv{[hւ̓]
						GetMenuItemInfo(ClipHistGetMenu(), LOWORD(wParam), FALSE, &mii); 
						mid = (SMenuItemData*)mii.dwItemData;
						if (mid != NULL) { SetClipData(mid->mText); }

						g.Processed = FALSE;
						HIST_SetHook(hWnd, wnd);
						SetForegroundWindow(wnd);
					}
			}
			break;
		case WM_MEASUREITEM:
			if (((LPMEASUREITEMSTRUCT)lParam)->CtlType == ODT_MENU)
			{
				LPMEASUREITEMSTRUCT	mis	= (LPMEASUREITEMSTRUCT)lParam;
				HDC					dc	= GetDC(hWnd);
				HGDIOBJ				old	= SelectObject(dc, gMenuFont.mFont);
				RECT				r	= { 0, 0, 300, gMenuFont.mMetric.tmHeight };
				SMenuItemData*		mid = (SMenuItemData*)mis->itemData;

				if (mid != NULL && IDM_POPUP_HISBASE <= mis->itemID && (mis->itemID - IDM_POPUP_HISBASE) < TESTHIST_COUNT)
				{
					DrawTextAW(mid->mText->mIsUnicode, dc, mid->mItemText, &r, DT_END_ELLIPSIS | DT_MODIFYSTRING | DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE);
					mis->itemWidth = r.right + 12 + gMenuFont.mMetric.tmMaxCharWidth;
					mis->itemHeight = gMenuFont.mMetric.tmHeight + 2;
				}
				SelectObject(dc, old);
				ReleaseDC(hWnd, dc);
				return TRUE;
			}
			break;
		case WM_DRAWITEM:
			if (((LPDRAWITEMSTRUCT)lParam)->CtlType == ODT_MENU)
			{
				wchar_t				num[8];
				MENUITEMINFO		mii	= { sizeof(MENUITEMINFO), };
				LPDRAWITEMSTRUCT	dis	= (LPDRAWITEMSTRUCT)lParam;
				SMenuItemData*		mid = (SMenuItemData*)dis->itemData;
				HGDIOBJ				old	= SelectObject(dis->hDC, gMenuFont.mFont);
				RECT				r	= dis->rcItem;
				HBRUSH				brush;

				mii.fMask		= MIIM_ID | MIIM_STRING;
				mii.cch			= 8;
				mii.dwTypeData	= (LPWSTR)num;
				if (mid != NULL && GetMenuItemInfoW(ClipHistGetMenu(), dis->itemID, FALSE, &mii))
				{
					brush = (dis->itemState == ODS_SELECTED) ? 
						dc_set_color(dis->hDC, COLOR_HIGHLIGHT, COLOR_HIGHLIGHTTEXT) :
						dc_set_color(dis->hDC, COLOR_MENU, COLOR_MENUTEXT);

					FillRect(dis->hDC, &dis->rcItem, brush);
					++r.top; r.left += 8;
					DrawText(dis->hDC, mii.dwTypeData, -1, &r, DT_SINGLELINE);

					r.left += gMenuFont.mMetric.tmMaxCharWidth + 4;
					DrawTextAW(mid->mText->mIsUnicode, dis->hDC, mid->mItemText, &r, DT_NOPREFIX | DT_SINGLELINE);
				}
				SelectObject(dis->hDC, old);
			}
			break;
		case WM_MENUSELECT:
			if ((HMENU)lParam == ClipHistGetMenu() && IDM_POPUP_HISBASE <= LOWORD(wParam))
			{
				MENUITEMINFO	mii		= { sizeof(MENUITEMINFO), };
				HMENU			hMenu	= (HMENU)lParam;
				UINT			id		= LOWORD(wParam);
				UINT			idx;
				UINT			count;
				SMenuItemData*	mid;

				mii.fMask = MIIM_ID | MIIM_DATA;
				for (idx = 0, count = GetMenuItemCount(hMenu);idx < count;++idx)
				{
					if (id == GetMenuItemID(hMenu, idx)) { break; }
				}

				GetMenuItemInfoW(hMenu, idx, TRUE, &mii);
				mid = (SMenuItemData*)mii.dwItemData;
				if (mid != NULL)
				{
					BYTE buffer[2048];
					RECT r;
					GetMenuItemRect(hWnd, hMenu, idx, &r);
					
					if (mid->mText->mIsUnicode) { ToolTipSetTextW(conv_tab_spece_w((LPWSTR)buffer, 1024, (LPCWSTR)mid->mText->mData)); }
					else { ToolTipSetTextA(conv_tab_spece_a((LPSTR)buffer, 2048, (LPCSTR)mid->mText->mData)); }
					ToolTipShow(r.right + 6, r.top);
				}
			}
			else if (lParam == 0 && HIWORD(wParam) == 0xffff)
			{
				ToolTipHide();
			}
			break;
		case WM_USER_TASKTRAY:
			if (LOWORD(lParam) == WM_RBUTTONDOWN)
			{
				POINT pos;
				GetCursorPos(&pos);
				SetForegroundWindow(hWnd);
				SetFocus(hWnd);
				TrackPopupMenuEx(gPopupMenu, 0, pos.x, pos.y, hWnd, NULL);
			}
			break;
		case WM_USER_KEYHOOK:
			if (g.NowLParam != lParam)
			{
				g.NowLParam = lParam;
				if (wParam == VK_CONTROL)
				{
					CheckModifireKey(&g.DownCtrl, 0, lParam);
				}
				else if (g.DownCtrl != 0 && (lParam & 0xc0000000) == 0)
				{
					if (wParam == 'V')
					{
						SetTimer(hWnd, TIMER_ID_PASTE, ELAPSE_PASTE, NULL);
						return 0;
					}
					else if (wParam == 'X' || wParam == 'C')
					{
						SetTimer(hWnd, TIMER_ID_COPY, ELAPSE_COPY, NULL);
						return 0;
					}
				}
			}
			break;
		case WM_USER_MSGHOOK:
			if (g.Processed == FALSE)
			{
				Sleep(150); // Ɗmȕ@͖̂B
				SendInput(4, sInput, sizeof(INPUT));
				g.Processed = TRUE;
				HIST_ResetHook();
			}
			break;
		case WM_HOTKEY:
			switch (wParam)
			{
				case HOTKEY_HISTORY:
					if (ClipHistIsEmpty())
					{
						MessageBeep(MB_ICONEXCLAMATION);
					}
					else
					{
						// Lbgʒu̎擾
						GUITHREADINFO info = { sizeof(GUITHREADINFO), };
						POINT pos;
						if (GetGUIThreadInfo(0, &info) && info.hwndCaret)
						{
							pos.x = info.rcCaret.left;
							pos.y = info.rcCaret.top + (info.rcCaret.bottom - info.rcCaret.top) / 2;
							ClientToScreen(info.hwndCaret, &pos);
						}
						else
						{
							GetCursorPos(&pos);
						}
						sHPrev = info.hwndActive;
						SetForegroundWindow(hWnd);
						SetFocus(hWnd);
						TrackPopupMenuEx(ClipHistGetMenu(), 0, pos.x, pos.y, hWnd, NULL);
						g.IsCtrl = (GetKeyState(VK_LCONTROL) | GetKeyState(VK_RCONTROL)) & 0x8000;
						SetForegroundWindow(info.hwndActive);
					}
					break;
				case HOTKEY_TOGGLE_FIFO:
					toggle_fifo();
					break;
				case HOTKEY_TOGGLE_LOOP:
					toggle_loop();
					break;
				case HOTKEY_TOGGLE_LINE:
					toggle_line();
					break;
#ifdef _DEBUG
				case HOTKEY_EXIT:
					post_quit_message();
					break;
#endif
			}
			return 0;
		case WM_TIMER:
			KillTimer(hWnd, wParam);
			switch (wParam)
			{
				case TIMER_ID_COPY:
					{
						SText* tp = NULL;
						if (GetClipData(&tp))
						{
							int i = (g.FIFOState != FB_STATE_OFF) - 1;
							if (gIsLineMode)
							{
								// Line copy mode.
								SText* tmp = NULL;
								LPCVOID cur = TextGetLine(tp->mData, &tmp, tp->mIsUnicode);

								while (cur != NULL)
								{
									if (tmp != NULL)
									{
										ClipHistAdd(tmp);
										if (i >= 0) { ClipTextPush(tmp); ++i; }
									}
									cur = TextGetLine(cur, &tmp, tp->mIsUnicode);
								}
								if (i > 0)
								{
									TaskTrayChangeState((((g.FIFOState & FB_STATE_FIFO_MASK) == g.FIFOState) ? ETTI_FIFO_COPY : ETTI_LOOP_COPY));
									ClipTextCurrent(&tmp);
									SetClipData(tmp);
								}
								TextRelease(&tmp);
							}
							else
							{
								ClipHistAdd(tp);
								if (g.FIFOState != FB_STATE_OFF)
								{
									ETaskTrayState state = (((g.FIFOState & FB_STATE_FIFO_MASK) == g.FIFOState) ? ETTI_FIFO_COPY : ETTI_LOOP_COPY);

									ClipTextPush(tp);
									TaskTrayChangeState(state);
									ClipTextCurrent(&tp);

									SetClipData(tp);
								}
							}
						}
						TextRelease(&tp);
					}
					break;
				case TIMER_ID_PASTE:
					if (g.FIFOState != FB_STATE_OFF)
					{
						SText* tp = NULL;
						if (g.FIFOState & FB_STATE_FIFO_MASK)
						{
							ClipTextPop();
							if (ClipTextIsEmpty()) { mode_off(); }
							else if (ClipTextTop(&tp)) { set_clip_and_tooltip(tp, ETTI_FIFO_PASTE); }
						}
						else
						{
							if (!ClipTextNext(&tp)) { mode_off(); }
							else { set_clip_and_tooltip(tp, ETTI_LOOP_PASTE); }
						}
						TextRelease(&tp);
					}
					break;
			}
			break;
		default:
			return DefWindowProc(hWnd, msg, wParam, lParam);
	}
	return 0;
}

static __inline BOOL register_window_class( void )
{
	WNDCLASSEX wc = {
		sizeof(WNDCLASSEX),
		0,
		MainProc,
		0,
		0,
		gHInstance,
		FBLoadIcon(IDI_MAIN),
		LoadCursor(NULL, IDC_ARROW),
		(HBRUSH)(COLOR_BTNFACE + 1),
		NULL,
		CLASSNAME,
		FBLoadIcon(IDI_MAIN_SM)
	};
	// EBhENX̓o^
	return (RegisterClassEx(&wc) != 0);
}

int __cdecl FBExit( void )
{
	FIFO_ResetHook();
	hotkey_off();

	ClipTextReset();
	ClipHistTerm();

	ToolTipTerm();
	FontTerm();
	TaskTrayTerm();

	SettingTerm();

	if (g.Mutex ){ CloseHandle(g.Mutex); }
	return 0;
}

#define INIT_CHECK(b, type)	if (!(b)) { initErrorType = type; goto end; }

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	MSG		msg;
	LPCWSTR	initErrorType = NULL;

	msg.wParam = -1;

	gHInstance = hInstance;

	// 2dN`FbN
	if ((g.Mutex = OpenMutex(MUTEX_ALL_ACCESS, FALSE, MUTEXNAME)) == NULL)
	{
		g.Mutex = CreateMutex(NULL, TRUE, MUTEXNAME);
	}
	else
	{
		MessageBox(NULL, FLIPBOARD_NAME L" ͊ɋNĂ܂B", L"x", MB_ICONWARNING | MB_APPLMODAL | MB_OK);
		return 0;
	}

	// 
	SET_MEMDEBUG();
	setlocale(LC_ALL, "jpn");
	InitCommonControls();
	onexit(FBExit);

	// ݒǂݍ
	SettingInit();

	// EChENXo^
	INIT_CHECK(register_window_class(), L"EChENX");

	// EChE쐬
	gHWnd = CreateWindowEx(0, CLASSNAME, WINDOWNAME, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		NULL, NULL, hInstance, NULL);
	INIT_CHECK(gHWnd, L"EChE");

	// Nbv
	INIT_CHECK(ClipHistInit(), L"Nbv");

	// c[`bv
	INIT_CHECK(ToolTipInit(0, 1024), L"c[`bv");

	// j[tHg
	INIT_CHECK(FontInit(L"MS Gothic", 12), L"j[tHg");

	// ^XNgC̏
	INIT_CHECK(TaskTrayInit(), L"^XNgCACR");

	// zbgL[L
	hotkey_on();
	// tbNJn
	FIFO_SetHook(gHWnd);

	// EBhEbZ[W
	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

end:
	if (initErrorType != NULL) { ErrorMessage(L"%s̏Ɏs܂B", initErrorType); }
	return msg.wParam;
}

void __cdecl ErrorMessage( LPCWSTR format, ... )
{
	wchar_t buffer[512];
	va_list va;
	va_start(va,format);
	vswprintf_s(buffer, 512, format, va);

	MessageBox(NULL, buffer, L"G[", MB_ICONERROR | MB_APPLMODAL | MB_OK);
	va_end(va);
}
HICON __fastcall FBLoadIcon( UINT id )
{
	return LoadIcon(gHInstance, MAKEINTRESOURCE(id));
}

