/*!
 * @file	dllmain.c
 * @author	Mitsunagi Studio
 * @version	1.04
 */
#include "stdafx.h"
#include "fifo.h"

#pragma data_seg("FBFIFO@103")
static HHOOK	gHHook		= NULL;
static HHOOK	gRHook		= NULL;
static HWND		gHWnd		= NULL;
static HWND		gHWndTarget	= NULL;
#pragma data_seg()
HINSTANCE gHInstance;

LRESULT CALLBACK FIFOHookProc( int nCode, WPARAM wParam, LPARAM lParam )
{
	if (nCode == HC_ACTION) { PostMessage(gHWnd, WM_USER_KEYHOOK, wParam, lParam); }
	return CallNextHookEx(gHHook, nCode, wParam, lParam);
}

LRESULT CALLBACK HISTHookProc( int nCode, WPARAM wParam, LPARAM lParam )
{
	if (nCode == HC_ACTION &&
		((CWPRETSTRUCT*)lParam)->hwnd == gHWndTarget &&
		LOWORD(GetQueueStatus(QS_ALLEVENTS)) == 0)
	{
		PostMessage(gHWnd, WM_USER_MSGHOOK, wParam, lParam);
	}
	return CallNextHookEx(gRHook, nCode, wParam, lParam);
}

BOOL APIENTRY DllMain( HMODULE hModule, DWORD urfc, LPVOID lpReserved )
{
	if (urfc == DLL_PROCESS_ATTACH) { gHInstance = (HINSTANCE)hModule; }
	return TRUE;
}

DLLFUNC(FIFO_SetHook)( HWND hWnd )
{
	if (gHHook) { return TRUE; }
	gHHook = SetWindowsHookEx(WH_KEYBOARD, FIFOHookProc, gHInstance, 0);
	gHWnd = hWnd;
	return (gHHook != NULL);
}

DLLFUNC(FIFO_ResetHook)( void )
{
	if (gHHook == NULL) { return TRUE; }
	if (UnhookWindowsHookEx(gHHook)) { gHHook = NULL; }
	return (gHHook == NULL);
}

DLLFUNC(HIST_SetHook)( HWND hWnd, HWND hWndTarget )
{
	if (gRHook) { return TRUE; }
	gRHook = SetWindowsHookEx(WH_CALLWNDPROCRET, HISTHookProc, gHInstance, 0);
	gHWnd = hWnd;
	gHWndTarget = hWndTarget;
	return (gRHook != NULL);
}

DLLFUNC(HIST_ResetHook)( void )
{
	if (!gRHook) { return TRUE; }
	if (UnhookWindowsHookEx(gRHook)) { gRHook = NULL; }
	return (gRHook == NULL);
}
