/*!
 * @file	debugf.c
 * @author	Mitsunagi Studio
 * @version	1.04
 */
#include <stdio.h>
#include <stdarg.h>
#include "cmndbg.h"

#ifdef _DEBUG

#define BUFFER_SIZE 1024

__declspec(dllimport) void __stdcall OutputDebugStringA( const char* );
__declspec(dllimport) void __stdcall OutputDebugStringW( const wchar_t* );

void __cdecl debugf( const char* format, ... )
{
	va_list va;
	va_start(va, format);
	vdebugf(format, va);
}
void __cdecl wdebugf( const wchar_t* format, ... )
{
	va_list va;
	va_start(va, format);
	vwdebugf(format, va);
}

void __fastcall vdebugf( const char* format, va_list va )
{
	char buffer[BUFFER_SIZE];
	vsprintf_s(buffer, 1024, format, va);
	OutputDebugStringA(buffer);
}
void __fastcall vwdebugf( const wchar_t* format, va_list va )
{
	wchar_t buffer[BUFFER_SIZE];
	vswprintf_s(buffer, 1024, format, va);
	OutputDebugStringW(buffer);
}

#else

void __cdecl debugf( const char* format, ... )
{
	va_list va;
	va_start(va, format);
	vprintf(format, va);
}
void __cdecl wdebugf( const wchar_t* format, ... )
{
	va_list va;
	va_start(va, format);
	vwprintf(format, va);
}

void __fastcall vdebugf( const char* format, va_list va )
{
	vprintf(format, va);
}
void __fastcall vwdebugf( const wchar_t* format, va_list va )
{
	vwprintf(format, va);
}

#endif
