/*!
	@file	FBXModel.cpp
	@brief	bVE{[f[^擾
	@author	Ó
*/
#include "stdafx.h"
#include "FBX2SL3D.h"
#include "FBXData.h"
#include "global.h"
#include "GUID.h"

/*!
	@brief	bVE{[̎擾
	@param	light	[in]	bVf[^
	@param	data	[in]	i[f[^
	@return	擾ꂽbVE{[̃f[^
*/
bool GetMesh( KFbxMesh* mesh, FBXData* data )
{
	int polyCount		= mesh->GetPolygonCount();				// |S
	int polyVtxCount	= mesh->GetPolygonVertexCount();		// CfbNX
	int controlNum		= mesh->GetControlPointsCount();		// _
	int materialCount	= mesh->GetNode()->GetMaterialCount();	// }eAf[^
	KFbxLayerElementNormal* normals = NULL;
	KFbxLayerElementVertexColor* colors = NULL;
	KFbxSurfaceMaterial* material = NULL;
	KFbxNode* node = mesh->GetNode();
	FBX_Mesh* m = new FBX_Mesh;
	LPCSTR attach_bone_name = NULL;

	KFbxSkin* skin = NULL;					// XL

	int vertex_size = 12;					// _f[^̃TCYiftHg͒_WTCYj
	int index_size;							// CfbNXl̃TCY
	int max_weights = 0;					// {[őe
	int uv_count = 0;						// UV 
	int matreial_count = 0;					// L}eA
	int clusterNum = 0;						// LNX^
	KFbxLayerElementUV* uv_layer = NULL;	// UV ̂郌C[f[^

	// CfbNXl̃TCY̌
	index_size = (polyVtxCount < 65535) ? 2 : 4;

	// ftHgeCNɐݒ肷iԂ̈ʒu擾邽߁j
	mesh->GetScene()->SetCurrentTake(KFBXTAKENODE_DEFAULT_NAME);

	/*-----------------------------------------------------------------------*/
	/* WE`FbNtFCY                                            */
	/*-----------------------------------------------------------------------*/

	// S3p`|S`FbN
	for(int p = 0; p < polyCount;++p){
		if(mesh->GetPolygonSize(p) != 3){
			Error("|S3p`ł͖bV܂F(%s)", m->name);
		}
	}
	// vZlƈvĂ邩`FbN
	_ASSERTE(polyCount * 3 == polyVtxCount);

	// XL񂪂邩mF
	int skin_count = mesh->GetDeformerCount(KFbxDeformer::eSKIN);
	if(skin_count != 0){
		// XL񂪂ꍇAe_̉e֌Wdő吔擾

		// XLf[^擾
		skin = (KFbxSkin*)mesh->GetDeformer(0, KFbxDeformer::eSKIN);
		// NX^i{[j擾
		clusterNum = skin->GetClusterCount();

		// ݂ĂNX^ MAX_BONES(128) 𒴂ꍇ̓G[oi_VF[_Ή̂߁jB
		if(clusterNum > MAX_BONES) Error("{[ %d 𒴂Ă܂BF(%d)", MAX_BONES, clusterNum);

		// 擪{[̖O擾
		attach_bone_name = skin->GetCluster(0)->GetName();

		// {[edvZꎞ̈m
		int* bones = (int*)calloc(controlNum, sizeof(int));

		// 
		for(int i = 0;i < clusterNum;++i){
			KFbxCluster* cluster = skin->GetCluster(i);
			int pointNum = cluster->GetControlPointIndicesCount();
			for(int *p = cluster->GetControlPointIndices(), *pend = p + pointNum;p < pend;++p){
				// _CfbNXƃEFCg擾
				if(++bones[*p] > max_weights) max_weights = bones[*p];
			}
			// 擪{[̖O擾
			if(i == 0) attach_bone_name = cluster->GetName();
		}
		// ꎞ̈
		delete bones;

		// {[ed 4 𒴂ꍇ̓G[oiΉƂ邽߁jB
		if(max_weights > 4){ Error("{[ed4𒴂Ă܂BF(%d)", max_weights); return NULL; }

		// bVo͂ꍇA{[ẽTCYtB( + 4 ̓{[CfbNXl̕)
		if((g.ExportFrag & EXPF_MESH) != 0) vertex_size += max_weights * sizeof(float) + 4;
	}

	// @̎擾ibVo͂Ȃꍇ͔΂j
	if((g.ExportFrag & EXPF_MESH) != 0){
		// @̂郌C[
		int layerNum = mesh->GetLayerCount();
		for(int i = 0;i < layerNum;++i){
			normals = mesh->GetLayer(i)->GetNormals();
			if(normals) break;
		}
		// @񂪂ꍇA@̃TCYtB
		if(normals) vertex_size += sizeof(D3DVECTOR);
	}

	// _J[̎擾ibVo͂Ȃꍇ͔΂j
	if((g.ExportFrag & EXPF_MESH) != 0){
		// _J[̂郌C[
		int layerNum = mesh->GetLayerCount();
		for(int i = 0;i < layerNum;++i){
			colors = mesh->GetLayer(i)->GetVertexColors();
			if(colors) break;
		}
		// _J[񂪂ꍇA_J[̃TCYtB
		if(colors) vertex_size += sizeof(D3DCOLOR);
	}

	// UV 񐔂̎擾ibVo͂Ȃꍇ͔΂j
	if((g.ExportFrag & EXPF_MESH) != 0){
		int layerNum = mesh->GetLayerCount();
		// UV W݂郌C[𐔂
		for(int i = 0;i < layerNum;++i){
			KFbxLayerElementUV* uv = mesh->GetLayer(i)->GetUVs();
			if(uv){
				if(!uv_layer) uv_layer = uv;
				++uv_count;
			}
		}
		// UV  1 ȏ゠郁bV̓T|[gȂiƎdlj
		if(uv_count > 1) Error("UV 񂪑܂B(őUV1łA%d݂܂)", uv_count);
		// UṼTCYtB
		vertex_size += uv_count * sizeof(D3DXVECTOR2);
	}

	// }eǍ̎擾ibVo͂Ȃꍇ͔΂j
	if((g.ExportFrag & EXPF_MESH) != 0){
		for(int i = 0;i < materialCount;++i){
			KFbxSurfaceMaterial* mat = node->GetMaterial(i);
			if(mat){
				if(!material) material = mat;
				++matreial_count;
			}
		}
		// }eA񂪈̃bVɕꍇ̓T|[gȂiƎdl<-\Hj
		if(matreial_count > 1) Error("}eA񂪑܂B(%d݂܂)", matreial_count);
	}

	// bV`FbN
	if(strlen(mesh->GetName()) >= MAX_NAME) Error("O܂B31ȓɗ}ĂB\n(\"%s\"<%d>)", mesh->GetName(), strlen(mesh->GetName()));

	/*-----------------------------------------------------------------------*/
	/* i[tFCY                                                      */
	/*-----------------------------------------------------------------------*/

	// Ỹf[^ւ̃ItZbg
	int vertex_offset = 12;

	// bV
	m->name = mesh->GetName();
	// bVzu
	SetSRT(m->initSRT, mesh->GetNode());
	
	m->bone_count = clusterNum;			// {[

	// bV̏o
	if(g.ExportFrag & EXPF_MESH){
		m->poly_count = polyCount;				// |S
		m->max_weight = max_weights;			// {[ed
		m->vertex_count = controlNum;			// _
		m->index_count = polyVtxCount;			// CfbNX
		m->uv_count = uv_count;					// UV 
		m->use_normal = (BYTE)(normals != NULL);// @gptO
		m->use_color = (BYTE)(colors != NULL);	// _J[gptO
		m->vertex_size = vertex_size;			// 1_̃TCY

		// _f[^̊m
		m->vertex = calloc(vertex_size, controlNum);
		if(!m->vertex) Error("_̊mۂɎs܂B(%d byte)", vertex_size * controlNum);

		// CfbNXf[^̊m
		m->index = malloc(polyVtxCount * index_size);
		if(!m->index) Error("CfbNX̊mۂɎs܂B(%d byte)", polyVtxCount * index_size);

		// _f[^ւ̊i[(ʒu)
		{
			BYTE* cur = (BYTE*)m->vertex;
			KFbxVector4* pos = mesh->GetControlPoints();
			for(int i = 0;i < controlNum;++i, ++pos, cur += vertex_size){
				((float*)cur)[0] = (float)pos->GetAt(0);
				((float*)cur)[2] = (float)pos->GetAt(1);
				((float*)cur)[1] = (float)pos->GetAt(2);
			}
		}
		// _f[^ւ̊i[(@)
		if(normals){
			BYTE* cur = (BYTE*)m->vertex + vertex_offset;
			KFbxLayerElementArrayTemplate<KFbxVector4>& direct = normals->GetDirectArray();
			if(normals->GetReferenceMode() == KFbxLayerElement::eDIRECT){
				// _CNgf[^̏ꍇ

				// _CNgf[^̌擾
				int directCount = direct.GetCount();
				// _f[^̌ƈvĂ邩`FbN
				_ASSERTE(directCount == controlNum);

				// _f[^ɑ
				for(int i = 0;i < directCount;++i, cur += vertex_size){
					KFbxVector4& pos = direct.GetAt(i);
					((float*)cur)[0] = (float)pos.GetAt(0);
					((float*)cur)[2] = (float)pos.GetAt(1);
					((float*)cur)[1] = (float)pos.GetAt(2);
				}
			}
			else{ // eINDEX_TO_DIRECT
				// CfbNXQƃf[^̏ꍇ
				KFbxLayerElementArrayTemplate<int>& index = normals->GetIndexArray();
				// CfbNXf[^̌擾
				int indexCount = index.GetCount();
				// _f[^̌ƈvĂ邩`FbN
				_ASSERTE(indexCount == controlNum);

				// _f[^ɑ
				for(int i = 0;i < indexCount;++i, cur += vertex_size){
					KFbxVector4& pos = direct.GetAt(index.GetAt(i));
					((float*)cur)[0] = (float)pos.GetAt(0);
					((float*)cur)[2] = (float)pos.GetAt(1);
					((float*)cur)[1] = (float)pos.GetAt(2);
				}
			}
			vertex_offset += 12;
		}
		// _f[^ւ̊i[(J[)
		if(colors){
			BYTE* cur = (BYTE*)m->vertex + vertex_offset;
			KFbxLayerElementArrayTemplate<KFbxColor>& direct = colors->GetDirectArray();
			if(normals->GetReferenceMode() == KFbxLayerElement::eDIRECT){
				// _CNgf[^̏ꍇ

				// _CNgf[^̌擾
				int directCount = direct.GetCount();
				// _f[^̌ƈvĂ邩`FbN
				_ASSERTE(directCount == controlNum);

				// _f[^ɑ
				for(int i = 0;i < directCount;++i, cur += vertex_size){
					SetD3DCOLOR(*(D3DCOLOR*)cur, direct.GetAt(i));
				}
			}
			else{ // eINDEX_TO_DIRECT
				// CfbNXQƃf[^̏ꍇ
				KFbxLayerElementArrayTemplate<int>& index = colors->GetIndexArray();
				// CfbNXf[^̌擾
				int indexCount = index.GetCount();
				// _f[^̌ƈvĂ邩`FbN
				_ASSERTE(indexCount == controlNum);

				// _f[^ɑ
				for(int i = 0;i < indexCount;++i, cur += vertex_size){
					SetD3DCOLOR(*(D3DCOLOR*)cur, direct.GetAt(index.GetAt(i)));
				}
			}
			vertex_offset += sizeof(D3DCOLOR);
		}
		// _f[^ւ̊i[(UV)
		if(uv_layer){
			BYTE* cur = (BYTE*)m->vertex + vertex_offset;
			KFbxLayerElementArrayTemplate<KFbxVector2>& direct = uv_layer->GetDirectArray();

			// UV Wf[^擾
			if(uv_layer->GetReferenceMode() == KFbxLayerElement::eDIRECT){
				// _CNgf[^̏ꍇ

				// _CNgf[^̌擾
				int directCount = direct.GetCount();
				// _f[^̌ƈvĂ邩`FbN
				_ASSERTE(directCount == controlNum);

				// _f[^ɑ
				for(int i = 0;i < directCount;++i, cur += vertex_size){
					KFbxVector2& pos = direct.GetAt(i);
					((float*)cur)[0] = (float)pos.GetAt(0);
					((float*)cur)[1] = (float)pos.GetAt(1);
				}
			}
			else{ // eINDEX_TO_DIRECT
				// CfbNXQƃf[^̏ꍇ
				KFbxLayerElementArrayTemplate<int>& index = uv_layer->GetIndexArray();
				// CfbNXf[^̌擾
				int indexCount = index.GetCount();
				// _f[^̌ƈvĂ邩`FbN
				//_ASSERTE(indexCount == controlNum);

				// _f[^ɑ
				for(int i = 0;i < /*indexCount*/controlNum;++i, cur += vertex_size){
					KFbxVector2& pos = direct.GetAt(index.GetAt(i));
					((float*)cur)[0] = (float)pos.GetAt(0);
					((float*)cur)[1] = (float)pos.GetAt(1);
				}
			}
			vertex_offset += 8;
		}
		// _f[^ւ̊i[({[)
		if(max_weights > 0){
			int weight_idx_ofs = max_weights * sizeof(float);
			BYTE* cur = (BYTE*)m->vertex + vertex_offset + weight_idx_ofs;
			int max_widx = max_weights - 1;
			// ɒ_f[^̃EFCgCfbNXl
			for(int i = 0;i < controlNum;++i, cur += vertex_size){
				*(ULONG*)cur = 0xffffffff;
			}

			// EFCglƃEFCgCfbNXl̊i[
			for(int i = 0;i < clusterNum;++i){
				KFbxCluster* cluster = skin->GetCluster(i);
				int		pointNum = cluster->GetControlPointIndicesCount();	// EFCgCfbNXz
				double*	weights = cluster->GetControlPointWeights();		// EFCgz
				// _f[^̊i[ꏊ̎Zo
				cur = (BYTE*)m->vertex + vertex_offset;
				// {[EFCgƃ{[ID𒸓_f[^Ɋi[
				for(int *p = cluster->GetControlPointIndices(), *pend = p + pointNum;p < pend;++p, cur += vertex_size){
					int j = 0;
					// CfbNXʒu
					BYTE* widx = cur + weight_idx_ofs;
					// CfbNXl̃ZbgEZbg
					for(;j < max_widx && *widx != 255;++j, ++widx);
					*widx = (BYTE)i;
					((float*)cur)[j] = (float)weights[*p];
				}
			}
		}

		// CfbNXf[^̊i[
		if(index_size == 2){
			USHORT*	cur = (USHORT*)m->index;
			int*	idx = mesh->GetPolygonVertices();
			for(int i = 0;i < polyVtxCount;++i, ++cur, ++idx) *cur = (USHORT)*idx;
		}
		else{ // index_size == 4
			ULONG*	cur = (ULONG*)m->index;
			int*	idx = mesh->GetPolygonVertices();
			for(int i = 0;i < polyVtxCount;++i, ++cur, ++idx) *cur = (ULONG)*idx;
		}

		// }eÅi[
		if(material){
			FBX_Material& mat = m->material;
			// o[gf[^}eA擾
			KFbxSurfaceLambert* lambert = (KFbxSurfaceLambert*)material;

//			mat.name = material->GetName();	// }eA
			SetD3DCOLORVALUE(mat.Ambient, lambert->GetAmbientColor(), lambert->GetAmbientFactor());		// ArGg
			SetD3DCOLORVALUE(mat.Diffuse, lambert->GetDiffuseColor(), lambert->GetDiffuseFactor());		// fBt[Y
			SetD3DCOLORVALUE(mat.Emissive, lambert->GetEmissiveColor(), lambert->GetEmissiveFactor());	// G~bVu

			if(material->GetClassId().Is(KFbxSurfacePhong::ClassId)){
				// tHOf[^}eA擾
				KFbxSurfacePhong* phong = (KFbxSurfacePhong*)material;
				SetD3DCOLORVALUE(mat.Specular, phong->GetSpecularColor());	// XyL
				mat.Power = phong->GetSpecularFactor().Get(); // XyLx
			}
			else{
				mat.Specular.a = mat.Specular.r = mat.Specular.g = mat.Specular.b = 0.0f;
				mat.Power = 0.0f;
			}

			// fBt[YeNX`̎擾(1̂)
			if(g.ExportFrag & EXPF_IN_TEXTURE){
				KFbxProperty prop = material->FindProperty(KFbxSurfaceMaterial::sDiffuse);
				int layerNum = prop.GetSrcObjectCount(KFbxLayeredTexture::ClassId);

				if(layerNum == 0){ // ʏf[^̂ݏ
					int texture_count = prop.GetSrcObjectCount(KFbxTexture::ClassId); // eNX`擾
					if(texture_count > 0){
						// eNX`̎擾
						char buf[_MAX_PATH];
						KFbxTexture* texture = KFbxCast<KFbxTexture>(prop.GetSrcObject(KFbxTexture::ClassId, 0));
						sprintf_s(buf, "%s%s", data->base_dir, texture->GetFileName());
						if(fopen_s(&mat.texture_fp, buf, "rb") != 0)
							Error("eNX`t@C܂F(%s)");
					}
				}
			}
		}

		// {[̎擾
		if(clusterNum > 0){
			m->initRT = new RTData[clusterNum];
			for(int i = 0;i < clusterNum;++i){
				KFbxXMatrix		mat;
				KFbxCluster*	cluster = skin->GetCluster(i);

				// zusi̋tsj擾i]Eړ̂݁j
				mat = cluster->GetTransformLinkMatrix(mat).Inverse();
				ToVec3(m->initRT[i].r, mat.GetR());
				ToVec3(m->initRT[i].t, mat.GetT());
			}
		}
	}
	if(g.ExportFrag & EXPF_MESH_ANIM){
		// bVf̂̃Aj[V
		bool isInAnim = false;
		GetAnim(node, m->meshAnims, data, &isInAnim);
		if(!isInAnim && m->meshAnims){
			delete[] m->meshAnims;
			m->meshAnims = NULL;
		}
		// {[Aj[V
		// {[Aj[ṼXgf[^mہB
		m->boneAnims = new FBX_RTAnim*[clusterNum];
		if(!m->boneAnims) Error("s߂̃܂B");

		for(int i = 0;i < clusterNum;++i){
			GetAnim(skin->GetCluster(i)->GetLink(), m->boneAnims[i], data);
		}
		
	}

	// f[^ǉ
	for(int i = 0;i < data->mesh_count;++i){
		if(data->mesh[i] == NULL){
			// f[^ǉAԂ
			data->mesh[i] = m;
			return true;
		}
	}
	// ɍő吔mۂĂ邪A
	// 炩̃oOȂǂłɗꍇׂ̈ _ASSERT d
	_ASSERT(false);
	return false;
}
