/*!
	@file	FBXLight.cpp
	@brief	Cgf[^擾
	@author	Ó
*/
#include "stdafx.h"
#include "FBX2SL3D.h"
#include "global.h"

/*!
	@brief	Cg̎擾
	@param	light	[in]	Cgf[^
	@param	data	[in]	i[f[^ił͎gpȂj
	@return	擾ꂽCg̃f[^
*/
bool GetLight( KFbxLight* light, FBXData* data )
{
	// Cgʂ̃`FbN
	if(light->LightType.Get() != KFbxLight::eDIRECTIONAL){
		Echo("\nWarning: Cg^Cv̓fBNViCĝݑΉ܂B(Ώۂ̃^Cv%sŁA̓XLbv܂)\n",
			(light->LightType.Get() == KFbxLight::ePOINT) ? "|CgCg" : "X|bgCg");
		return true; // ԂB
	}

	FBX_Light* l = new FBX_Light;		// Cg̃f[^m
	KFbxNode* node = light->GetNode();	// Cg񂪊i[Ăm[h擾

	// ftHgeCNɐݒ肷iԂ̈ʒu擾邽߁j
	light->GetScene()->SetCurrentTake(KFBXTAKENODE_DEFAULT_NAME);

	// Cg
	l->name		= light->GetName();

	if(g.ExportFrag & EXPF_LIGHT){
//		l->Type = D3DLIGHT_DIRECTIONAL;

		// CgF
		SetD3DCOLORVALUE(l->diffuse, light->Color);

		// Cgʒu
//		ToVec3(l->pos, node->GetGlobalFromCurrentTake(0).Double44());
		ToVec3(l->pos, node->LclTranslation.Get());

		// CǧixNgj
		{
			D3DXMATRIX mat;
			D3DXVECTOR4 out;
			D3DXVECTOR3 in(0.0f, 0.0f, -1.0f);
			fbxDouble3 rot = node->LclRotation.Get();
			double x = rot[0], y = rot[1], z = rot[2];
			D3DXMatrixRotationYawPitchRoll(&mat, (float)D3DXToRadian(rot[0]), (float)D3DXToRadian(rot[1]), (float)D3DXToRadian(rot[2]));
			D3DXVec4Normalize(&out, D3DXVec3Transform(&out, &in, &mat));
			l->direction.x =  out.x;
			l->direction.y =  out.y;
			l->direction.z = -out.z;
		}
//		if(node->GetTarget()) ToVec3(l->direction, node->GetTarget()->GetGlobalFromCurrentTake(0).Double44());
//		else l->direction.x = l->direction.y = l->direction.z = 0.1f;
	}

	// CgAj[V
	if(g.ExportFrag & EXPF_LIGHT_ANIM){
		bool isInAnim = false;
		GetAnim(light->GetNode(), l->anims, data, &isInAnim);
		if(!isInAnim && l->anims){
			delete[] l->anims;
			l->anims = NULL;
		}
	}

	// f[^ǉ
	for(int i = 0;i < data->light_count;++i){
		if(data->light[i] == NULL){
			// f[^ǉAԂ
			data->light[i] = l;
			return true;
		}
	}
	// ɍő吔mۂĂ邪A
	// 炩̃oOȂǂłɗꍇׂ̈ _ASSERT d
	_ASSERT(false);
	return false;
}
