/*!
	@file	FBXConvert.cpp
	@brief	FBX f[^oEϊ
	@author	Ó
*/
#include "stdafx.h"
#include "FBX2SL3D.h"
#include "global.h"
#include "GUID.h"

/*!
	@brief	ef[^̌̎擾ċA֐B
	@param	node	[in]	m[hB
	@param	data	[in]	Wf[^̊i[ꏊB
*/
static void CountCheckRef( KFbxNode* node, FBXData* data )
{
	int		num = node->GetChildCount();	// qm[ȟ
	DWORD	flag = g.ExportFrag;			// otOlX^bNɒu

	// e擾tỎۂ𐔒litrue -> 1, false -> 0jɕϊB
	int		isMesh		= (int)((flag & EXPF_MESH_WITH_ANIM) != 0);		// bV
	int		isCamera	= (int)((flag & EXPF_CAMERA_WITH_ANIM) != 0);	// J
	int		isLight		= (int)((flag & EXPF_LIGHT_WITH_ANIM) != 0);	// Cg

	KFbxNodeAttribute* attr = node->GetNodeAttribute();	// 

	if(attr){
		// m[h̑Ƃɕ
		switch(attr->GetAttributeType()){
			case KFbxNodeAttribute::eMESH:		// bV
				data->mesh_count += isMesh;
				/*
				// bVɃ{[܂܂Ă邩`FbN
				if(((KFbxMesh*)attr)->GetDeformerCount(KFbxDeformer::eSKIN) > 0){
					KFbxSkin* skin = (KFbxSkin*)((KFbxMesh*)attr)->GetDeformer(0, KFbxDeformer::eSKIN);
					data->bone_count += (int)(skin->GetClusterCount() > 0);
				}
				*/
				break;
			case KFbxNodeAttribute::eCAMERA:	// J
				data->camera_count += isCamera;
				break;
			case KFbxNodeAttribute::eLIGHT:		// Cg
				if(((KFbxLight*)attr)->LightType.Get() == KFbxLight::eDIRECTIONAL){
					// fBNViCĝ݃JEg
					data->light_count += isLight;
				}
				break;
		}
	}

	// qm[h𑖍
	for(int i = 0;i < num;++i){
		CountCheckRef(node->GetChild(i), data);
	}
}

/*!
	@brief	ef[^̌擾ċA֐B
	@param	node	[in]	m[hB
	@param	data	[in]	Wf[^̊i[ꏊB
	@return	ǂB
*/
static bool GetDataRef( KFbxNode* node, FBXData* data )
{
	int		num = node->GetChildCount();	// qm[ȟ
	DWORD	flag = g.ExportFrag;			// otOlX^bNɒu

	KFbxNodeAttribute*	attr = node->GetNodeAttribute();	// 

	if(attr){
		// m[h̑Ƃɕ
		switch(attr->GetAttributeType()){
			case KFbxNodeAttribute::eMESH:		// bVE{[
				if(flag & EXPF_MESH_WITH_ANIM){
					if(!GetMesh((KFbxMesh*)attr, data)) return false;
				}
				break;
			case KFbxNodeAttribute::eCAMERA:	// J
				if(flag & EXPF_CAMERA_WITH_ANIM){
					if(!GetCamera((KFbxCamera*)attr, data)) return false;
				}
				break;
			case KFbxNodeAttribute::eLIGHT:		// Cg
				if(flag & EXPF_LIGHT_WITH_ANIM){
					if(!GetLight((KFbxLight*)attr, data)) return false;
				}
				break;
		}
	}

	// qm[h𑖍
	for(int i = 0;i < num;++i){
		if(!GetDataRef(node->GetChild(i), data)) return false;
	}

	return true;
}

/*!
	@brief	ef[^̃f[^mۃev[g֐
	@param	count	[in]	mۂ
	@return	mۂꂽf[^B count  0 Ȃ NULL B
*/
template <class T>
static inline T** NewPArray( ULONG count ){
	if(count > 0){
		T** t = new T*[count];
		memset(t, 0, sizeof(T*) * count);
		return t;
	}
	return NULL;
}

/*!
	@brief	񒊏oEo͊֐B
	@return	ǂB
*/
bool Convert( void )
{
	KFbxSdkManager*				sdk;			// FBX SDK }l[W
	KFbxImporter*				importer;		// FBX C|[^
	KFbxStreamOptionsFbxReader*	options = NULL;	// FBX C|[gIvV
	KFbxScene*					scene;			// FBX V[f[^

	int		fileFormat = -1;			// t@CtH[}bg
	int		sdkMaj, sdkMin, sdkRev;		// FBX SDK o[W擾ϐ
	int		fileMaj, fileMin, fileRev;	// t@Co[W擾ϐ
	bool	result;						// ʂ̎擾ϐ
	int		i, n;						// for pꎞϐ

	// FBX SDK o[W擾E\
	KFbxIO::GetCurrentVersion(sdkMaj, sdkMin, sdkRev);
	Echo("FDX SDK Version:%d.%d.%d\n", sdkMaj, sdkMin, sdkRev );

	// e FBX IuWFNg쐬
	sdk			= KFbxSdkManager::Create();
	scene		= KFbxScene::Create(sdk, "");
	importer	= KFbxImporter::Create(sdk, "");
	// SDK }l[WO[oϐɊi[Ă
	g.Sdk = sdk;

	// t@CtH[}bg̑I
	if(!sdk->GetIOPluginRegistry()->DetectFileFormat(g.InputPath, fileFormat)){
		fileFormat = sdk->GetIOPluginRegistry()->GetNativeReaderFormat();
	}

	// t@CtH[}bgC|[^ɃZbgEB
	importer->SetFileFormat(fileFormat);
	result = importer->Initialize(g.InputPath);
	// t@Co[W擾
	importer->GetFileVersion( fileMaj, fileMin, fileRev );

	if(!result){
		// C|[^̏Ɏs
		// G[bZ[W\
		printf("\nError : FBX ǂݍ݃G[(%08x)\"%s\"\n", importer->GetLastErrorID(), importer->GetLastErrorString());
		if(importer->GetLastErrorID() == KFbxIO::eFILE_VERSION_NOT_SUPPORTED_YET || 
			importer->GetLastErrorID() == KFbxIO::eFILE_VERSION_NOT_SUPPORTED_ANYMORE) 
		{
			printf("       FBX SDK T|[gĂȂo[WłB\n");
		}
		return false;
	}
	// t@Co[W\
	Echo( "InputFile  :[Ver %d.%d.%d].\n", fileMaj, fileMin, fileRev );

	// t@CtH[}bg FBX `̏ꍇ
	if(importer->IsFBX()){
		// Ńt@CAj[VȂǂ̎擾̐s
		int iTakeCount = importer->GetTakeCount();
		bool loadAnim = ((g.ExportFrag & EXPF_ANIM_ALL) != 0);
		for(i = 0;i < iTakeCount;++i){
			importer->GetTakeInfo(i)->mSelect = loadAnim;
		}
#if FBXFILESDK_NAMESPACE == fbxsdk_200903
		// C|[gݒpNX̍쐬
		options = KFbxStreamOptionsFbxReader::Create(sdk, "");
		if(!options){
			printf("\nError : FBX C|[gݒɎs܂B\n");
			return false;
		}
		options->SetOption(KFBXSTREAMOPT_FBX_MATERIAL,			true);
		options->SetOption(KFBXSTREAMOPT_FBX_TEXTURE,			true);
		options->SetOption(KFBXSTREAMOPT_FBX_LINK,				true);
		options->SetOption(KFBXSTREAMOPT_FBX_SHAPE,				true);
		options->SetOption(KFBXSTREAMOPT_FBX_GOBO,				false);
		options->SetOption(KFBXSTREAMOPT_FBX_ANIMATION,			loadAnim);
		options->SetOption(KFBXSTREAMOPT_FBX_GLOBAL_SETTINGS,	true);

#else
		// fbxsdk_2010ȍ~̃o[Wł͉L̃R[h
		// ǂݎwłlqB
        IOSREF.SetBoolProp(IMP_FBX_MATERIAL,        true);
        IOSREF.SetBoolProp(IMP_FBX_TEXTURE,         true);
        IOSREF.SetBoolProp(IMP_FBX_LINK,            true);
        IOSREF.SetBoolProp(IMP_FBX_SHAPE,           true);
        IOSREF.SetBoolProp(IMP_FBX_GOBO,            false);
        IOSREF.SetBoolProp(IMP_FBX_ANIMATION,       loadAnim);
        IOSREF.SetBoolProp(IMP_FBX_GLOBAL_SETTINGS, true);
#endif
	}

	// C|[gsAV[Ɋi[
	result = importer->Import(scene, options);

	// C|[^
	importer->Destroy();
	if(options) options->Destroy();

	if(result){
		// C|[g
		KFbxNode* node = scene->GetRootNode();

		// qm[hOɎ擾
		int num = node->GetChildCount();
		// i[f[^̈m
		FBXData* data = new FBXData;
		strncpy_s(data->base_dir, g.InputPath, PathFindFileNameA(g.InputPath) - g.InputPath);

		// WJn
		Echo("W");

		// V[擾
		data->name = scene->GetName();

		for(i = 0;i < num;++i){
			// m[hKwef[^̌擾iAj[V͉L̂ق̏Ŏ擾j
			CountCheckRef(node->GetChild(i), data);
		}
		// Ro[głeʂ`FbN
		if(data->mesh_count		> MAX_MESHES)	Error("bVRo[głő吔𒴂Ă܂B(%4d/%4d)", data->mesh_count, MAX_MESHES);
		if(data->camera_count	> MAX_CAMERAS)	Error("JRo[głő吔𒴂Ă܂B(%4d/%4d)", data->camera_count, MAX_CAMERAS);
		if(data->light_count	> MAX_LIGHTS)	Error("CgRo[głő吔𒴂Ă܂B(%4d/%4d)", data->light_count, MAX_LIGHTS);
//		if(data->bone_count		> MAX_BONES)	Error("{[ReiRo[głő吔𒴂Ă܂B(%4d/%4d)", data->bone_count, MAX_BONES);
		// ef[^̔z̈m
		data->mesh = NewPArray<FBX_Mesh>(data->mesh_count);
		data->camera = NewPArray<FBX_Camera>(data->camera_count);
		data->light = NewPArray<FBX_Light>(data->light_count);
//		data->bone = NewPArray<FBX_Bone>(data->bone_count);

		// ԏ̎擾
		{
			KTime::ETimeMode mode = scene->GetGlobalTimeSettings().GetTimeMode();
			// t[[g̎擾
			switch(mode){
				case KTime::eFRAMES60: data->ticks_per_second = 60; break;
				case KTime::eFRAMES30: data->ticks_per_second = 30; break;
				default:
					if(g.ExportFrag & EXPF_ANIM_ALL){
						Error("ΉĂȂt[[głB");
					}
					else{
						// Aj[Vo͂Ȃꍇ͓Kɐݒ
						mode = KTime::eFRAMES60;
						data->ticks_per_second = 60;
					}
			}
			// 1t[ KTime l擾
			data->period.SetTime(0, 0, 0, 1, 0, mode);
		}
		Echo(".");
		if(g.ExportFrag & EXPF_ANIM_ALL){
			// Aj[Vo͂ꍇ
			KArrayString takeNames;

			// eCN擾
			scene->FillTakeNameArray(takeNames);
			for(i = 0, n = takeNames.GetCount();i < n;++i){
				KFbxTakeInfo* info = scene->GetTakeInfo(*takeNames[i]);
				LPCSTR name = takeNames[i]->Buffer();
				// eCN񂪎擾łAftHgeCNł͂Ȃ̂JEg
				if(info && takeNames[i]->Compare(KFBXTAKENODE_DEFAULT_NAME) != 0){
					// eCN擾
					data->take_names.Add(takeNames[i]);
				}
				else{
					// eCN񂪂ȂA邢̓ftHgeCNꍇ
					// ̖O͕svȂ̂ŉB
					delete takeNames[i];
				}
			}
			// eCN̔z̈m
			data->takeinfo_count = data->take_names.GetCount();
			// i[ł`FbN
			if(data->takeinfo_count	> MAX_TAKEINFOS)	Error("Aj[VRo[głő吔𒴂Ă܂B(%4d/%4d)", data->takeinfo_count, MAX_TAKEINFOS);
			data->takeinfo = new FBX_TakeInfo[data->takeinfo_count];

			// eeCN擾
			for(i = 0;i < data->takeinfo_count;++i){
				KFbxTakeInfo* info = scene->GetTakeInfo(*data->take_names[i]);
				FBX_TakeInfo& takeinfo = data->takeinfo[i];
				// Aj[Vf[^m
				takeinfo.name	= data->take_names[i]->Buffer();	// eCN
				takeinfo.start	= (ULONG)(info->mLocalTimeSpan.GetStart().Get() / data->period.Get());	// Aj[VJn(t[)
				takeinfo.end	= (ULONG)(info->mLocalTimeSpan.GetStop().Get() / data->period.Get());	// Aj[VI(t[)
			}
		}

		// f[^擾
		for(i = 0;i < num;++i){
			Echo(".");
			// ֐s break
			if(!(result = GetDataRef(node->GetChild(i), data))) break;
		}
		// L for  break ĂȂijꍇ
		if(i >= num){
			Echo("B\n");
			// o֐
			FBXOutput(data);
		}
		delete data;
	}

	if(!result){
		// C|[gs
		if(importer->GetLastErrorID() == KFbxIO::ePASSWORD_ERROR){
			// pX[ht̏ꍇ
			printf("Error: pX[htt@C͓ǂݍ߂܂B\n");
			// {pX[h̓͂𑣂đΏ邪Ał͍sȂB
			// āAG[ƂB
		}
		else{
			// LȊO
			// G[IDƃG[bZ[W\
			printf("Error : C|[gG[(%08x)\"%s\"\n", importer->GetLastErrorID(), importer->GetLastErrorString());
		}
		return false;
	}

	return true;
}
