/*!
	@file	FBXAnim.cpp
	@brief	Aj[Vf[^擾
	@author	Ó
*/
#include "stdafx.h"
#include "FBX2SL3D.h"
#include "global.h"

/*!
	@brief	J[u̎擾
	@param	curve	[in]	J[u
	@param	acurve	[out]	i[f[^
*/

struct TimeLineItem {
	kLongLong		mTime;
	int				mAxis;
	kFCurveIndex	mKey;
	float			mValue;

	bool operator<( const TimeLineItem& r )const{
		return (mTime < r.mTime);// || mAxis < r.mAxis);
	}
	bool operator>( const TimeLineItem& r )const{
		return (mTime > r.mTime);// || mAxis > r.mAxis);
	}

	void Swap( TimeLineItem& tli ){
		TimeLineItem t = tli;
		tli = *this;
		*this = t;
	}
};

static inline void SetKeyTimeAndAxis( KFCurve* kfc, TimeLineItem* &cur, int axis )
{
	for(int i = 0, n = kfc->KeyGetCount();i < n;++i, ++cur){
		cur->mTime = kfc->KeyGetTime(i).Get();
		cur->mAxis = axis;
		cur->mKey = i;
		cur->mValue = kfc->KeyGetValue(i);
	}
}

static void TimeLineItemQSort( TimeLineItem* tli, int left, int right )
{
	TimeLineItem* pivot = tli + ((left + right) / 2);
	int i = left - 1, j = right + 1;

	while(1){
		while(tli[++i] < *pivot);
		while(tli[--j] > *pivot);
		if(i >= j) break;

		tli[i].Swap(tli[j]);
	}
	if(left < i)	TimeLineItemQSort(tli, left, i - 1);
	if(j < right)	TimeLineItemQSort(tli, j + 1, right);
/*
loop:
	while(tli[i] < *pivot) ++i;
	while(tli[j] > *pivot) --j;
	if(i < j){
		tli[i].Swap(tli[j]);
		++i; --j;
		goto loop;
	}

	if(left < i - 1)	TimeLineItemQSort(tli, left, i - 1);
	if(j + 1 < right)	TimeLineItemQSort(tli, j + 1, right);
*/
}
/*
void TimeLineItemHSortSiftDown( TimeLineItem* tli, int root, int bottom )
{
	int done, maxChild;

	done = 0;
	while ((root * 2 <= bottom) && (!done)) {
		if (root * 2 == bottom) {
			maxChild = root * 2;
		} else if (tli[root * 2] > tli[root * 2 + 1]) {
			maxChild = root * 2;
		} else {
			maxChild = root * 2 + 1;
		}

		if (tli[root] < tli[maxChild]) {
			tli[root].Swap(tli[maxChild]);
			root = maxChild;
		} else {
			done = 1;
		}

	}
}
*/
void TimeLineItemHSortSiftDown( TimeLineItem* tli, int root, int bottom )
{
	int maxChild, x2 = root << 1;

	while(x2 <= bottom){
		maxChild = ((x2 == bottom || tli[x2] > tli[x2 + 1]) ? x2 : (x2 + 1));

		if (tli[root] < tli[maxChild]) {
			tli[root].Swap(tli[maxChild]);
			root = maxChild;
			x2 = maxChild << 1;
		}
		else return;
	}
}

static void TimeLineItemHSort( TimeLineItem* tli, int array_size )
{
	int i;

	/* {gAbvŃq[v\z */
	for(i = (array_size >> 1) - 1;i >= 0;--i)
	{
		TimeLineItemHSortSiftDown(tli, i, array_size);
	}

	/* q[v\[gs */
	for(i = array_size - 1;i >= 1;--i)
	{
		tli->Swap(tli[i]);
		TimeLineItemHSortSiftDown(tli, 0, i - 1);
	}
}

static inline float KLLLeap( const kLongLong& now, const kLongLong& prev, const kLongLong& next, float prevValue, kFCurveDouble nextValue ){
	return (float)((now - prev) * (nextValue - (long double)prevValue) / (next - prev) + prevValue);
}

//! XYZ el̂ЂƂ܂Ƃ܂ƂāAL[t[̌Ɗet[ʒu擾܂B
static D3DXKEY_VECTOR3* GetKFVec3( KFCurve* x, KFCurve* y, KFCurve* z, USHORT& count, const kLongLong& period, float defvalue ){
	count = 0;

	if(x == NULL || y == NULL || z == NULL) return NULL;

	ULONG len = 0;
	int xn = x->KeyGetCount(), yn = y->KeyGetCount(), zn = z->KeyGetCount();
	ULONG array_size = xn + yn + zn;

	if(array_size == 0) return NULL;

	D3DXKEY_VECTOR3* key = (D3DXKEY_VECTOR3*)malloc((sizeof(D3DXKEY_VECTOR3) + sizeof(TimeLineItem)) * array_size);
	D3DXKEY_VECTOR3* kcur = key;
	TimeLineItem* tli = (TimeLineItem*)(key + array_size);
	TimeLineItem* tcur = tli;

	// ẽL[ʒuׂ
	SetKeyTimeAndAxis(x, tcur, 0); // X
	SetKeyTimeAndAxis(y, tcur, 1); // Y
	SetKeyTimeAndAxis(z, tcur, 2); // Z

	_ASSERTE(tcur - tli == array_size);

	// \[giNCbN\[ggpj
//	TimeLineItemQSort(tli, 0, array_size - 1);
	TimeLineItemHSort(tli, array_size);

	tcur = tli;
	// L[t[ʒu擾EzɊi[
	D3DXVECTOR3 now(defvalue, defvalue, defvalue);
	D3DXVECTOR3 prev(defvalue, defvalue, defvalue);
	kFCurveIndex xi = 0, yi = 0, zi = 0;
	kLongLong xt = 0, yt = 0, zt = 0;
	kLongLong time;
	for(TimeLineItem* tn = tli + array_size;tcur < tn;++tcur, ++kcur, ++len){
		time = tcur->mTime;
		kcur->Time = (float)(time / period);
		int matched = 0;
		do{
			if(matched) ++tcur;
			switch(tcur->mAxis){
				case 0: prev.x = now.x; now.x = tcur->mValue; ++xi; xt = tcur->mValue; break;
				case 1: prev.y = now.y; now.y = tcur->mValue; ++yi; yt = tcur->mValue; break;
				case 2: prev.z = now.z; now.z = tcur->mValue; ++zi; zt = tcur->mValue; break;
				default: _ASSERT(false);
			}
			matched |= (1 << tcur->mAxis);
		}while(tcur < tn && tcur[0].mTime == tcur[1].mTime);

		kcur->Value.x = ((matched & 1) != 0 || xi == xn) ? now.x : KLLLeap(time, xt, x->KeyGetTime(xi).Get(), now.x, x->KeyGetValue(xi));
		kcur->Value.z = ((matched & 2) != 0 || yi == yn) ? now.y : KLLLeap(time, yt, y->KeyGetTime(yi).Get(), now.y, y->KeyGetValue(yi));
		kcur->Value.y = ((matched & 4) != 0 || zi == zn) ? now.z : KLLLeap(time, zt, z->KeyGetTime(zi).Get(), now.z, z->KeyGetValue(zi));
#if defined(_DEBUG) && 0
		printf("\nv%3d(%8.4f,%8.4f,%8.4f)[%3d,%3d,%3d]<%016llX:%3f>", len, kcur->Value.x, kcur->Value.y, kcur->Value.z, xi, yi, zi, time, kcur->Time);
		if(len != (UINT)kcur->Time) printf("*");
#endif
		_ASSERTE(tcur + 1 >= tn || tcur[0].mTime < tcur[1].mTime);
	}
	_ASSERTE(array_size >= len);
	_ASSERTE(tcur == (tli + array_size));
	_ASSERTE(kcur <= (key + array_size));
	_ASSERTE(len < 65536);

	count = (USHORT)len;

	// mۗ̈ L[t[ʒû݂̃TCYɏkĕԂ
	return (D3DXKEY_VECTOR3*)realloc(key, sizeof(D3DXKEY_VECTOR3) * count);
}
//! XYZ el̂ЂƂ܂Ƃ܂ƂāAL[t[̌Ɗet[ʒu擾܂B
static D3DXKEY_QUATERNION* GetKFQuat( KFCurve* x, KFCurve* y, KFCurve* z, USHORT& count, const kLongLong& period ){
	count = 0;

	if(x == NULL || y == NULL || z == NULL) return NULL;

	ULONG len = 0;
	int xn = x->KeyGetCount(), yn = y->KeyGetCount(), zn = z->KeyGetCount();
	ULONG array_size = xn + yn + zn;

	if(array_size == 0) return NULL;

	D3DXKEY_QUATERNION* key = (D3DXKEY_QUATERNION*)malloc((sizeof(D3DXKEY_QUATERNION) + sizeof(TimeLineItem)) * array_size);
	D3DXKEY_QUATERNION* kcur = key;
	TimeLineItem* tli = (TimeLineItem*)(key + array_size);
	TimeLineItem* tcur = tli;

	// ẽL[ʒuׂ
	SetKeyTimeAndAxis(x, tcur, 0); // X
	SetKeyTimeAndAxis(y, tcur, 1); // Y
	SetKeyTimeAndAxis(z, tcur, 2); // Z

	// \[gi܂ȂƂHj
//	TimeLineItemQSort(tli, 0, array_size - 1);
	TimeLineItemHSort(tli, array_size);

	tcur = tli;
	// L[t[ʒu擾EzɊi[
	D3DXVECTOR3 now(0.0f, 0.0f, 0.0f);
	D3DXVECTOR3 prev(0.0f, 0.0f, 0.0f);
	D3DXVECTOR3 rot(0.0f, 0.0f, 0.0f);
	kFCurveIndex xi = 0, yi = 0, zi = 0;
	kLongLong xt = 0, yt = 0, zt = 0;
	kLongLong time;
	for(TimeLineItem* tn = tli + array_size;tcur < tn;++tcur, ++kcur, ++len){
		time = tcur->mTime;
		kcur->Time = (float)(time / period);
		int matched = 0;
		do{
			if(matched) ++tcur;
			switch(tcur->mAxis){
				case 0: prev.x = now.x; now.x = tcur->mValue; ++xi; xt = tcur->mValue; break;
				case 1: prev.y = now.y; now.y = tcur->mValue; ++yi; yt = tcur->mValue; break;
				case 2: prev.z = now.z; now.z = tcur->mValue; ++zi; zt = tcur->mValue; break;
				default: _ASSERT(false);
			}
			matched |= (1 << tcur->mAxis);
		}while(tcur < tn && tcur[0].mTime == tcur[1].mTime);

		rot.x = -(((matched & 1) != 0 || xi == xn) ? now.x : KLLLeap(time, xt, x->KeyGetTime(xi).Get(), now.x, x->KeyGetValue(xi)));
		rot.y = -(((matched & 4) != 0 || zi == zn) ? now.z : KLLLeap(time, zt, z->KeyGetTime(zi).Get(), now.z, z->KeyGetValue(zi)));
		rot.z =  (((matched & 2) != 0 || yi == yn) ? now.y : KLLLeap(time, yt, y->KeyGetTime(yi).Get(), now.y, y->KeyGetValue(yi)));
		D3DXQuaternionRotationYawPitchRoll(&kcur->Value, D3DXToRadian(rot.x), D3DXToRadian(rot.y), D3DXToRadian(rot.z));
#if defined(_DEBUG) && 0
		printf("\nr%3d(%8.4f,%8.4f,%8.4f)[%3d,%3d,%3d]<%016llX:%3f>", len, rot.x, rot.y, rot.z, xi, yi, zi, time, kcur->Time);
		if(len != (UINT)kcur->Time) printf("*");
#endif
		_ASSERTE(tcur + 1 >= tn || tcur[0].mTime < tcur[1].mTime);
	}
	_ASSERTE(array_size >= len);
	_ASSERTE(tcur == (tli + array_size));
	_ASSERTE(kcur <= (key + array_size));
	_ASSERTE(len < 65536);

	count = (USHORT)len;

	// mۗ̈ L[t[ʒû݂̃TCYɏkĕԂ
	return (D3DXKEY_QUATERNION*)realloc(key, sizeof(D3DXKEY_QUATERNION) * count);
}

#define GETS_LCL(lclname) node->Lcl##lclname.GetKFCurve("X"), node->Lcl##lclname.GetKFCurve("Y"), node->Lcl##lclname.GetKFCurve("Z")
/*!
	@brief	Aj[V̎擾
	@param	node	[in]	m[h
	@param	anims	[out]	擾Aj[V
	@param	data	[in]	i[f[^
	@return	ǂ
*/
bool GetAnim( KFbxNode* node, FBX_SRTAnim* &anims, FBXData* data, bool* isInAnimData ){

	KFbxScene* scene = node->GetScene();	// V[IuWFNg擾
	kLongLong period = data->period.Get();
	int takes_count = data->take_names.GetCount();

	anims = new FBX_SRTAnim[takes_count];

	for(int i = 0;i < takes_count;++i){
		FBX_SRTAnim& anim = anims[i];
		KString* take = data->take_names.GetAt(i);

		// eCNZbg
		scene->SetCurrentTake(take->Buffer());
		if(take->Compare(node->GetCurrentTakeNodeName()) == 0){ // ̃eCNZbgĂƂ
			// J[u̎擾
			anim.trans	= GetKFVec3(GETS_LCL(Translation),	anim.trans_count,	period, 0.0f); // ړ
			anim.scale	= GetKFVec3(GETS_LCL(Scaling),		anim.scale_count,	period, 1.0f); // gk
			anim.rotate	= GetKFQuat(GETS_LCL(Rotation),		anim.rotate_count,	period); // ]
			if(anim.trans || anim.scale || anim.rotate){
				*isInAnimData = true;
			}
		}
		else{
			anim.trans	= NULL;
			anim.scale	= NULL;
			anim.rotate	= NULL;
		}
	}

	return true;
}
/*!
	@brief	Aj[V̎擾
	@param	node	[in]	m[h
	@param	anims	[out]	擾Aj[V
	@param	data	[in]	i[f[^
	@return	ǂ
*/
bool GetAnim( KFbxNode* node, FBX_RTAnim* &anims, FBXData* data ){

	KFbxScene* scene = node->GetScene();	// V[IuWFNg擾
	kLongLong period = data->period.Get();
	int takes_count = data->take_names.GetCount();

	anims = new FBX_RTAnim[takes_count];

	for(int i = 0;i < takes_count;++i){
		FBX_RTAnim& anim = anims[i];
		KString* take = data->take_names.GetAt(i);

		// eCNZbg
		scene->SetCurrentTake(take->Buffer());
		if(take->Compare(node->GetCurrentTakeNodeName()) == 0){ // ̃eCNZbgĂƂ
			// J[u̎擾
			anim.rotate	= GetKFQuat(GETS_LCL(Rotation),		anim.rotate_count,	period); // ]
			anim.trans	= GetKFVec3(GETS_LCL(Translation),	anim.trans_count,	period, 0.0f); // ړ
		}
		else{
			anim.rotate	= NULL;
			anim.trans	= NULL;
		}
	}

	return true;
}
#undef GETS_LCL
