/*!
	@file	FBXOutput.cpp
	@brief	FBX 擾Ǝ`ŏo͂R[hQ
	@author	Ó
*/
#include "stdafx.h"
#include "FBX2SL3D.h"
#include "global.h"
#include "GUID.h"

#define TEX_READ_BUFSIZE (1 << 16)


static const BYTE SL3DDT_DATA = SL3DDT_DATA_VALUE;
static const BYTE SL3DDT_ANIM_OBJ = SL3DDT_ANIM_OBJ_VALUE;
static const BYTE SL3DDT_ANIM_BONE = SL3DDT_ANIM_BONE_VALUE;
static const BYTE SL3D_ZERO = SL3D_ZERO_VALUE;

#define SWD(data, size) fwrite(data, size, 1, fp)

static void WriteAnimData( FBXData* fbx, FILE* fp, FBX_SRTAnim* anim, bool outputType = true ){
	if(outputType) SWD(&SL3DDT_ANIM_OBJ, 1);
	for(int i = 0;i < fbx->takeinfo_count;++i, ++anim){
		SWD(anim, offsetof(FBX_SRTAnim, trans));
		if(anim->scale_count > 0) SWD(anim->scale, sizeof(D3DXKEY_VECTOR3) * anim->scale_count);
		if(anim->rotate_count > 0) SWD(anim->rotate, sizeof(D3DXKEY_QUATERNION) * anim->rotate_count);
		if(anim->trans_count > 0) SWD(anim->trans, sizeof(D3DXKEY_VECTOR3) * anim->trans_count);
	}
}
static void WriteAnimData( FBXData* fbx, FILE* fp, FBX_RTAnim* anim, bool outputType = true ){
	if(outputType) SWD(&SL3DDT_ANIM_BONE, 1);
	for(int i = 0;i < fbx->takeinfo_count;++i, ++anim){
		SWD(anim, offsetof(FBX_RTAnim, trans));
		if(anim->rotate_count > 0) SWD(anim->rotate, sizeof(D3DXKEY_QUATERNION) * anim->rotate_count);
		if(anim->trans_count > 0) SWD(anim->trans, sizeof(D3DXKEY_VECTOR3) * anim->trans_count);
	}
}

static void WriteMesh( FBX_Mesh* m, FBXData* fbx, FILE* fp ){
	int index_size = (m->index_count < MAX_IDX16) ? 2 : 4;
	size_t texsize = 0;

	SWD(m->name, strlen(m->name)+1);
	if(g.ExportFrag & EXPF_MESH){
		SWD(&SL3DDT_DATA, 1);
		SWD(&m->initSRT, offsetof(FBX_Mesh, material) - offsetof(FBX_Mesh, initSRT));

		SWD(&m->material, sizeof(D3DMATERIAL9));
		if(m->material.texture_fp == NULL || (g.ExportFrag & EXPF_IN_TEXTURE) == 0) SWD(&texsize, 4);
		else{
			BYTE buffer[TEX_READ_BUFSIZE];
			FILE* fp = m->material.texture_fp;
			texsize = _filelength(_fileno(fp));
			SWD(&texsize, 4);
			while(texsize > 0){
				size_t read = fread(buffer, 1, TEX_READ_BUFSIZE, fp);
				if(read == 0) Error("eNX`f[^̓ǂݍݒɃG[܂B");
				SWD(buffer, read);
				texsize -= read;
			}
		}

		SWD(m->vertex, m->vertex_size * m->vertex_count);
		SWD(m->index, index_size * m->index_count);
		if(m->bone_count > 0) SWD(m->initRT, sizeof(RTData) * m->bone_count);
	}
	if(m->boneAnims){
		for(BYTE j = 0;j < m->bone_count;++j){
			WriteAnimData(fbx, fp, m->boneAnims[j]);
		}
	}
	else if(m->meshAnims){
		WriteAnimData(fbx, fp, m->meshAnims);
	}

	SWD(&SL3D_ZERO, 1);
}

static void WriteCamera( FBX_Camera* c, FBXData* fbx, FILE* fp ){
	SWD(c->name, strlen(c->name)+1);

	SWD(&SL3DDT_DATA, 1);
	SWD(&c->pos, offsetof(FBX_Camera, anims) - offsetof(FBX_Camera, pos));

	if(c->anims){
		WriteAnimData(fbx, fp, c->anims);
	}
	SWD(&SL3D_ZERO, 1);
}
static void WriteLight( FBX_Light* l, FBXData* fbx, FILE* fp ){
	SWD(l->name, strlen(l->name)+1);

	SWD(&SL3DDT_DATA, 1);
	SWD(&l->diffuse, offsetof(FBX_Light, anims) - offsetof(FBX_Light, diffuse));

	if(l->anims){
		WriteAnimData(fbx, fp, l->anims);
	}
	SWD(&SL3D_ZERO, 1);
}

static FILE* open_file( wchar_t* pathCur, size_t bufSize, const char* name,  int* defNum, const wchar_t* ext, const GUID* guid ){
	size_t		convSize;
	if(mbstowcs_s(&convSize, pathCur, bufSize - 5, name, _TRUNCATE) == 0){
		if(!name || *name == L'\0'){
			swprintf_s(pathCur, bufSize - 5, L"noname_%03d", *defNum);
			++*defNum;
		}
		wcscat_s(pathCur, bufSize, ext);
		Echo("\t%S\n", g.OutPath);
		FILE* fp;
		if(_wfopen_s(&fp, g.OutPath, L"wb") == 0){
			fwrite(guid, sizeof(GUID), 1, fp);
			return fp;
		}
		else{
			printf("Error: t@CJ܂F\"%S\"\n", g.OutPath);
		}
	}
	else{
		printf("Error: pX̐Ɏs܂B\n");
	}
	return NULL;
}

void FBXOutput( FBXData* data ){
	wchar_t*	pathCur;
	size_t		bufSize;
	int			defNum[3] = {0, };

	const GUID SL3DGUID_OBJECT		= SL3D_GUID_OBJECT;
	const GUID SL3DGUID_ANIMOBJECT	= SL3D_GUID_ANIMOBJECT;
	const GUID SL3DGUID_MESH		= SL3D_GUID_MESH;
	const GUID SL3DGUID_CAMERA		= SL3D_GUID_CAMERA;
	const GUID SL3DGUID_LIGHT		= SL3D_GUID_LIGHT;
	const GUID SL3DGUID_ANIMCAMERA	= SL3D_GUID_ANIMCAMERA;
	const GUID SL3DGUID_ANIMLIGHT	= SL3D_GUID_ANIMLIGHT;

	Echo("o͒:\n");

	bufSize = _MAX_PATH - wcslen(g.OutPath);
	pathCur = g.OutPath + wcslen(g.OutPath);

	// IuWFNg
	for(int i = 0;i < data->mesh_count;++i){
		FBX_Mesh* m = data->mesh[i];
		if(!m->name) continue;

		const wchar_t* ext;
		const GUID* guid;
		int id;
		if(m->boneAnims != NULL)		{ ext = SL3D_MESH_EXT;			guid = &SL3DGUID_MESH;			id = 2; }
		else if(m->meshAnims != NULL)	{ ext = SL3D_ANIMOBJECT_EXT;	guid = &SL3DGUID_ANIMOBJECT;	id = 1; }
		else							{ ext = SL3D_OBJECT_EXT;		guid = &SL3DGUID_OBJECT;		id = 0; }

		FILE* fp = open_file(pathCur, bufSize, m->name, defNum + id, ext, guid);
		if(!fp) continue;

		WriteMesh(m, data, fp);

		fclose(fp);
	}

	defNum[0] = defNum[1] = 0;
	// J
	for(int i = 0;i < data->camera_count;++i){
		FBX_Camera* cam = data->camera[i];
		if(!cam->name) continue;

		const wchar_t* ext;
		const GUID* guid;
		int id;
		if(cam->anims != NULL)	{ ext = SL3D_ANIMCAMERA_EXT;	guid = &SL3DGUID_ANIMCAMERA;	id = 1; }
		else					{ ext = SL3D_CAMERA_EXT;		guid = &SL3DGUID_CAMERA;		id = 0; }

		FILE* fp = open_file(pathCur, bufSize, cam->name, defNum + id, ext, guid);
		if(!fp) continue;

		WriteCamera(cam, data, fp);

		fclose(fp);
	}

	defNum[0] = defNum[1] = 0;
	// Cg
	for(int i = 0;i < data->light_count;++i){
		FBX_Light* light = data->light[i];
		if(!light->name) continue;

		const wchar_t* ext;
		const GUID* guid;
		int id;
		if(light->anims != NULL){ ext = SL3D_ANIMLIGHT_EXT;	guid = &SL3DGUID_ANIMLIGHT;	id = 1; }
		else					{ ext = SL3D_LIGHT_EXT;		guid = &SL3DGUID_LIGHT;		id = 0; }

		FILE* fp = open_file(pathCur, bufSize, light->name, defNum + id, ext, guid);
		if(!fp) continue;

		WriteLight(light, data, fp);

		fclose(fp);
	}

	Echo("o͏IB\n");
}
