/*!
	@file	FBXCamera.cpp
	@brief	Jf[^擾
	@author	Ó
*/
#include "stdafx.h"
#include "FBX2SL3D.h"
#include "global.h"

/*!
	@brief	J̎擾
	@param	camera	[in]	Jf[^
	@param	data	[in]	i[f[^ił͎gpȂj
	@return	擾ꂽJ̃f[^
*/
bool GetCamera( KFbxCamera* camera, FBXData* data )
{
	FBX_Camera* c = new FBX_Camera;		// J̃f[^m
	KFbxNode* node = camera->GetNode();	// J񂪊i[Ăm[h擾

	// ftHgeCNɐݒ肷iԂ̈ʒu擾邽߁j
	camera->GetScene()->SetCurrentTake(KFBXTAKENODE_DEFAULT_NAME);

	c->name = camera->GetName();	// J

	if(g.ExportFrag & EXPF_CAMERA){
		ToVec3(c->pos, camera->Position.Get());					// Jʒu
		ToVec3(c->at_pos, camera->InterestPosition.Get());	// J̒_
		ToVec3(c->up_vector, camera->UpVector.Get());									// J̏xNg
		c->nearY		= (float)camera->GetNearPlane();								// \͈͂̋ߒl
		c->farY			= (float)camera->GetFarPlane();									// \͈͂̉l
		// AXyNg
		c->aspect_rate	= (float)(camera->AspectWidth.Get() / camera->AspectHeight.Get());
		// Fov l
		c->fovY			= (float)atan2( 25.4 * camera->FilmHeight.Get() , 2.0 * camera->FocalLength.Get() );

		// near  far lȂftHglɃZbg
		if(c->nearY == c->farY){
			c->nearY = 0.1f;
			c->farY  = 1000.0f;
		}
	}

	// JCgAj[V
	if(g.ExportFrag & EXPF_CAMERA_ANIM){
		bool isInAnim = false;
		GetAnim(camera->GetNode(), c->anims, data, &isInAnim);
		if(!isInAnim && c->anims){
			delete[] c->anims;
			c->anims = NULL;
		}
	}

	// f[^ǉ
	for(int i = 0;i < data->camera_count;++i){
		if(data->camera[i] == NULL){
			// f[^ǉAԂ
			data->camera[i] = c;
			return true;
		}
	}
	// ɍő吔mۂĂ邪A
	// 炩̃oOȂǂłɗꍇׂ̈ _ASSERT d
	_ASSERT(false);
	return false;
}
