/*!
	@file	FBXData.h
	@brief	FBX f[^i[`Q
	@author	Ó
*/
#pragma once

typedef KArrayTemplate<KString*>	KArrayString;

inline BYTE LimitCutByte( double d ){
	int r = (int)(d * 255);
	return (r < 0) ? 0 : ((r > 255) ? 255 : r);
}

template<class T>
inline void ToVec3( T& dest, KFbxVector4* d ){
	dest.x = (float)d->GetAt(0);
	dest.z = (float)d->GetAt(1);
	dest.y = (float)d->GetAt(2);
}
template<class T>
inline void ToVec3( T& dest, KFbxVector4 d ){
	dest.x = (float)d.GetAt(0);
	dest.z = (float)d.GetAt(1);
	dest.y = (float)d.GetAt(2);
}
template<class T>
inline void ToVec3( T& dest, KFbxMatrix::kDouble44& d ){
	dest.x = (float)d[3][0];
	dest.z = (float)d[3][1];
	dest.y = (float)d[3][2];
}

template<class T>
inline void ToVec2( T& dest, KFbxVector2* d ){
	dest.x = (float)d->GetAt(0);
	dest.y = (float)d->GetAt(1);
}
template<class T>
inline void ToVec2( T& dest, KFbxVector2 d ){
	dest.x = (float)d.GetAt(0);
	dest.y = (float)d.GetAt(1);
}

inline void SetD3DCOLOR( D3DCOLOR& c, const KFbxColor& color ){
	c = (LimitCutByte(color.mAlpha) << 24) |
		(LimitCutByte(color.mRed) << 16) |
		(LimitCutByte(color.mGreen) <<  8) |
		(LimitCutByte(color.mBlue) <<  0);
}
inline void SetD3DCOLORVALUE( D3DCOLORVALUE& cv, KFbxPropertyDouble3 color, KFbxPropertyDouble1 factor ){
	cv.a = factor.Get();
	cv.r = color.Get()[0];
	cv.g = color.Get()[1];
	cv.b = color.Get()[2];
}
inline void SetD3DCOLORVALUE( D3DCOLORVALUE& cv, KFbxPropertyDouble3 color ){
	cv.a = 1.0f;
	cv.r = color.Get()[0];
	cv.g = color.Get()[1];
	cv.b = color.Get()[2];
}

struct SRTData {
	D3DVECTOR	s, r, t;
};
struct RTData {
	D3DVECTOR	r, t;
};

inline void SetSRT( SRTData& dest, const KFbxNode* src ){
	dest.s.x =  src->LclScaling.Get()[0];
	dest.s.z =  src->LclScaling.Get()[1];
	dest.s.y =  src->LclScaling.Get()[2];
	dest.r.x =  src->LclRotation.Get()[0];
	dest.r.z =  src->LclRotation.Get()[1];
	dest.r.y =  src->LclRotation.Get()[2];
	dest.t.x =  src->LclTranslation.Get()[0];
	dest.t.z =  src->LclTranslation.Get()[1];
	dest.t.y =  src->LclTranslation.Get()[2];
}

struct FBX_SRTAnim {
	USHORT	trans_count;
	USHORT	scale_count;
	USHORT	rotate_count;
	USHORT	padding;

	D3DXKEY_VECTOR3*	trans;
	D3DXKEY_VECTOR3*	scale;
	D3DXKEY_QUATERNION*	rotate;

	FBX_SRTAnim( void ){ memset(this, 0, sizeof(*this)); }

	~FBX_SRTAnim( void ){
		if(trans) delete[] trans;
		if(scale) delete[] scale;
		if(rotate) delete[] rotate;
	}
};
struct FBX_RTAnim {
	USHORT	trans_count;
	USHORT	rotate_count;

	D3DXKEY_VECTOR3*	trans;
	D3DXKEY_QUATERNION*	rotate;

	FBX_RTAnim( void ){ memset(this, 0, sizeof(*this)); }

	~FBX_RTAnim( void ){
		if(trans) delete[] trans;
		if(rotate) delete[] rotate;
	}
};

struct FBX_Bone {
	LPCSTR			name;
	USHORT			count;
	BYTE			use_anims;
	BYTE			reserved;
	RTData*			initRT;
	FBX_RTAnim**	anims;

	FBX_Bone( void ){ memset(this, 0, sizeof(*this)); }

	~FBX_Bone( void ){
		if(initRT) delete initRT;
		if(anims){
			for(int i = 0;i < count;++i){
				if(anims[i]) delete[] anims[i];
			}
			delete[] anims;
		}
	}
};

struct FBX_Material : public D3DMATERIAL9 {
	FILE* texture_fp;

	FBX_Material( void ){ memset(this, 0, sizeof(*this)); }
	~FBX_Material( void ){ if(texture_fp) fclose(texture_fp); }
};

struct FBX_Mesh {
	LPCSTR			name;
	SRTData			initSRT;

	BYTE			vertex_size;
	BYTE			bone_count;
	BYTE			max_weight:4;
	BYTE			uv_count:4;
	BYTE			use_normal:1;
	BYTE			use_color:1;
	BYTE			reserved:6;

	ULONG			poly_count;
	ULONG			vertex_count;
	ULONG			index_count;
	FBX_Material	material;
	void*			vertex;
	void*			index;

	FBX_SRTAnim*	meshAnims;

	RTData*			initRT;
	FBX_RTAnim**	boneAnims;


	FBX_Mesh( void ){ memset(this, 0, sizeof(*this)); }

	~FBX_Mesh( void ){
		if(vertex) free(vertex);
		if(index) free(index);
		if(meshAnims) delete[] meshAnims;
		if(initRT) delete[] initRT;
		if(boneAnims){
			for(BYTE i = 0;i < bone_count;++i){
				if(boneAnims[i]) delete[] boneAnims[i];
			}
			delete[] boneAnims;
		}
	}
};

struct FBX_Camera {
	LPCSTR			name;
	D3DXVECTOR3		pos;
	D3DXVECTOR3		at_pos;
	D3DXVECTOR3		up_vector;
	float			nearY;
	float			farY;
	float			aspect_rate;
	float			fovY;
	FBX_SRTAnim*	anims;

	~FBX_Camera( void ){
		if(anims) delete[] anims;
	}
};

struct FBX_Light {
	LPCSTR			name;
	D3DCOLORVALUE	diffuse;
//	D3DCOLORVALUE	specular;
//	D3DCOLORVALUE	ambient;
	D3DXVECTOR3		pos;
	D3DXVECTOR3		direction;
	FBX_SRTAnim*	anims;

	FBX_Light( void ):name(NULL){ memset(this, 0, sizeof(*this)); }

	~FBX_Light( void ){
		if(anims) delete[] anims;
	}
};

//! eCN
struct FBX_TakeInfo {
	LPCSTR	name;
	ULONG	start;
	ULONG	end;
};

struct FBXData {
	LPCSTR				name;
	USHORT				mesh_count;
	USHORT				camera_count;
	USHORT				light_count;
	USHORT				takeinfo_count;
	FBX_Mesh**			mesh;
	FBX_Camera**		camera;
	FBX_Light**			light;
	FBX_TakeInfo*		takeinfo;

	DWORD				ticks_per_second;

	// L͏o͑ΏۊO
	KTime				period;
	KArrayString		take_names;
	char				base_dir[_MAX_PATH];

	FBXData( void ){ memset(this, 0, offsetof(FBXData, period)); }

	~FBXData( void ){
		if(mesh){
			for(int i = 0;i < mesh_count;++i) delete mesh[i];
			delete[] mesh;
		}
		if(camera){
			for(int i = 0;i < camera_count;++i) delete camera[i];
			delete[] camera;
		}
		if(light){
			for(int i = 0;i < light_count;++i) delete light[i];
			delete[] light;
		}
		if(takeinfo){
			delete[] takeinfo;
		}
		DeleteAndClear(take_names);
	}
};
