/*!
	@file	FBX2SL3D.cpp
	@brief	C[`
	@author	Ó
*/
#include "stdafx.h"
#include "global.h"
#include "FBX2SL3D.h"

/*!
	@brief	fobOo
	@param	format	[in]	
*/
void _debugf( const char* format, ... )
{
	va_list va;
	va_start(va, format);
	vprintf_s(format, va);
	va_end(va);
}

/*!
	@brief	WóiR}hC -ne w肵ꍇ͏o͂Ȃj
	@param	format	[in]	
*/
void Echo( const char* format, ... )
{
	if(g.NoEcho) return;
	va_list va;
	va_start(va, format);
	vprintf_s(format, va);
	va_end(va);
}

/*!
	@brief	G[ói exit Ăяoj
	@param	format	[in]	
*/
void Error( const char* format, ... ){
	va_list va;
	va_start(va, format);
	printf("\nError: ");
	vprintf_s(format, va);
	printf("\n");
	va_end(va);
	g.OnError = true;
	exit(-1);
}

/*!
	@brief	
	@param	argc	[in]	R}hC̐
	@param	argv	[in]	R}hC̔z
*/
static void Initialize( int argc, wchar_t* argv[] )
{
	int ofs = 1;
	DWORD frag = 0;

	setlocale(LC_ALL, "jpn");	// UNICODE -> ANSI œ{Ή

	g.ExportFrag = EXPF_DEFAULT;	// ftHgtOw
	g.NoEcho = false;				// ftHgŕWo͂s

	while(argc > ofs && argv[ofs][0] == L'-'){
		// R}hC '-' Ŏn܂Ƃ
		const wchar_t* wh = argv[ofs] + 1;
		if(wcscmp(wh, L"ne") == 0){
			// '-ne' : Wo͂sȂIvViG[͕\j
			g.NoEcho = true;
		}
		else{
			// f[^o͎wIvV
			while(*wh != L'\0'){
				switch(*wh){
					case L'm': frag |= EXPF_MESH; break;		// '-m' : bVf[^o
					case L'c': frag |= EXPF_CAMERA; break;		// '-c' : Jf[^o
					case L'l': frag |= EXPF_LIGHT; break;		// '-l' : Cgf[^o
					case L'd': frag |= EXPF_DATA_ALL; break;	// '-d' : Aj[VȊÕf[^o

					// ȉL̃Aj[Vtp[^
					case L'M': frag |= (*(wh+1) == L'a') ? (++wh, EXPF_MESH_ANIM) : EXPF_MESH_WITH_ANIM; break;		// '-M' , '-Ma'
					case L'C': frag |= (*(wh+1) == L'a') ? (++wh, EXPF_CAMERA_ANIM) : EXPF_CAMERA_WITH_ANIM; break;	// '-C' , '-Ca'
					case L'L': frag |= (*(wh+1) == L'a') ? (++wh, EXPF_LIGHT_ANIM) : EXPF_LIGHT_WITH_ANIM; break;	// '-L' , '-La'
					case L'D': frag |= (*(wh+1) == L'a') ? (++wh, EXPF_ANIM_ALL) : EXPF_ALL; break;					// '-D' , '-Da'

					// feNX`̗̓L
					case L't': frag |= EXPF_IN_TEXTURE; break;	// '-t' eNX`f[^ϊt@C܂߂
					case L'T': frag &= ~EXPF_IN_TEXTURE; break;	// '-T' eNX`f[^܂߂ȂiQƂ܂j

					// ȊOiG[j
					default: Error("sȈn܂B");
				}
				++wh;
			}
		}
		++ofs;
	}

	// c̈Ȃi̓t@CpXj
	if(argc <= ofs) Error("̓t@C܂B");

	{
		char buffer[MAX_PATH_UTF8];
		char fullPath[MAX_PATH_UTF8];
		size_t retSize;

		// ̓t@C̐΃pX UTF8 ɕϊĎ擾
		if(wcstombs_s(&retSize, buffer, argv[ofs], _TRUNCATE) != 0 ||
			_fullpath(fullPath, buffer, MAX_PATH_UTF8) == NULL)
		{
			Error("̓pX܂B");
		}
		KFBX_ANSI_to_UTF8(fullPath, g.InputPath);
		++ofs;
	}

	if(argc <= ofs){
		// o̓pXw肳ĂȂ
		wchar_t buffer[_MAX_PATH];
		wcscpy_s(buffer, argv[ofs-1]);
		// ̓pX̊gq̂o̓pX̃x[XƂĐ
		for(wchar_t* wh = buffer + wcslen(buffer) - 1;wh > buffer;--wh){
			if(*wh == L'.'){
				*wh = L'_';
				break;
			}
		}
		// o̓pXۑ
		wcscpy_s(g.OutPath, buffer);
	}
	else{
		// o̓pXۑ
		wcscpy_s(g.OutPath, argv[ofs]);
	}

	// G[tȌ
	g.OnError = false;
	// frag w肳ĂtOXV
	if(frag) g.ExportFrag = frag;
}
/*!
	@brief	
*/
static void Finalize( void )
{
	if(g.OnError){
		// G[ꍇAo̓t@C폜
		_wremove(g.OutPath);
/*
#ifdef _DEBUG
		getchar(); // G[̊mF̂߁AfobOłł͈ꎞ~
#endif
*/
	}
}

static int ReleaseSDK( void ){
	if(g.Sdk){
		// FBX IuWFNg
		g.Sdk->Destroy();
		//  sdk->Destroy()  scene ܂ޑSẴIuWFNĝŁA
		// V[ȂǑ̃f[^̊J͕svB
	}
#ifdef _DEBUG
	// G[̊mF̂߁AfobOłł͈ꎞ~
	if(g.OnError) getchar();
	else  Sleep(1000);
#endif
	return 0;
}

/*!
	@brief	C֐iUNICODE Łj
	@param	argc	[in]	R}hC̐
	@param	argv	[in]	R}hC̔z
*/
int wmain( int argc, wchar_t* argv[] )
{
	int result; // ʂi[ϐ

#ifdef _DEBUG
	// fobOłł̓[N`FbN
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF|_CRTDBG_LEAK_CHECK_DF);
#endif

	// 
	Initialize(argc, argv);

	onexit(ReleaseSDK);

	// Ro[gs
	result = Convert();

	// 
	Finalize();

	// ʂԂ
	return result;
}

